function d_error( str, arg1, arg2, arg3 )
%D_ERROR is the database of all the error and warning messages generated
%        by all the DfP functions.
%
%        D_ERROR( STRING, A1, A2, ... ) is the format to call this function
%        where the input argument STRING is the unique label which identifies
%        the error/warning message.  A1,A2,... represent the additional
%        information required by the particular error/warning STRING.  The 
%        convention for the STRING is as follows:
%        STRING = 'LAA-xx' 
%                  ||  |
%                  ||  +----> Two digit integer 01,02,... identifier
%                  |+-------> Two character identifier for the source window
%                  |          T :  Filter Type & Specifications
%                  |          M :  Filter Method
%                  |          QU:  Quantizer
%                  |          O :  Output
%                  |          P :  Properties
%                  |          G :  General
%                  +--------> Single character label
%                             E : error
%                             W : warning

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

%=================================
% OUTPUT window generated messages
%=================================
%
%  ERRORs
%==========
if ( strcmp(str,'EO-01') )

 s = [ ...
 'DFP-Output ERROR (Code EO-01):\n' ...
 '==============================\n' ...
 'You must specify array name(s) to transfer data to MATLAB workspace.\n'...
 'Enter comma or space delimited array name(s) as required.\n'  ];

elseif ( strcmp(str,'EO-02') )

 s = [ ...
 'DFP-Output ERROR (Code EO-02):\n' ...
 '==============================\n' ...
 'You must specify array name(s) to transfer data to MATLAB workspace.\n'...
 'Enter comma or space delimited array names for the "numerator" and\n'  ...
 '"denominator" polynomials (in that particular order).\n'];

elseif ( strcmp(str,'EO-03') )

 s = [ ...
 'DFP-Output ERROR (Code EO-03):\n' ...
 '==============================\n' ...
 'You must specify array name(s) to transfer data to MATLAB workspace.\n'...
 'Enter an array name for the "Reflection" coefficient polynomials. \n' ];

elseif ( strcmp(str,'EO-04') )

 s = [ ...
 'DFP-Output ERROR (Code EO-04):\n' ...
 '==============================\n' ...
 'You must specify array name(s) to transfer data to MATLAB workspace.\n'...
 'Enter comma or space delimited array names for the "Reflection" and \n'...
 '"c" coefficient polynomials (in that particular order).\n'];

elseif ( strcmp(str,'EO-05') )

 s = [ ...
 'DFP-Output ERROR (Code EO-05):\n' ...
 '==============================\n' ...
 'You must specify array name(s) to transfer data to MATLAB workspace.\n'...
 'Enter comma or space delimited array names for the "SOS" array and the\n'...
 '"gain" coefficient (in that particular order).\n'];

elseif ( strcmp(str,'EO-06') )

 arg1 = strrep(arg1,'\','\\'); 
 arg2 = strrep(arg2,'\','\\'); 
 s = [ ...
 'DFP-Output ERROR (Code EO-06):\n' ...
 '==============================\n' ...
 'The file:\n\n\t' arg1 ...
 '\n\ncannot be found or opened.  Possible cause of error is that the DFP\n'...
 'variable DFP_TemplatesDir:\n\n\t' arg2 ...
 '\n\nwhich identifies the location of template files, is not correctly\n'...
 'specified or it does not contain the required template files.\n' ];
 
%
%  WARNINGs
%===========
elseif ( strcmp(str,'WO-01') )

 if ( arg1 > 1 )
    nostr = 'coefficients exceed';
 else
    nostr = 'coefficient exceeds';
 end
 s = [ ...
 'DFP-Output WARNING (Code WO-01):\n' ...
 '================================\n' ...
 num2str(arg1) ' filter ' nostr ' the expected input data range [-1,1).\n' ...
 'As a result of saturation, the filter implementation on the DSP\n'...
 'may not conform to the DFP design.\n' ];

%====================================
%  TYPESPEC CHECK generated messages
%====================================

elseif ( strcmp(str,'ET-01') )

 s = [ ...
 'DFP-TYPE & SPECIFICATIONS CHECKING ERROR (Code ET-01):\n' ...
 '======================================================\n' ...
 'Sampling frequency must be positive.\n' ];

elseif ( strcmp(str,'ET-02') )

 s = [ ...
 'DFP-TYPE & SPECIFICATIONS CHECKING ERROR (Code ET-02):\n' ...
 '======================================================\n' ...
 'All the intermediate filter frequencies such as the passband and\n' ...
 'stopband edge frequencies must be less than or equal to fs/2.\n' ];

elseif ( strcmp(str,'ET-03') )

 s = [ ...
 'DFP-TYPE & SPECIFICATIONS CHECKING ERROR (Code ET-03):\n' ...
 '======================================================\n' ...
 'Inconsistent intermediate filter frequency specification.  For example\n' ...
 'for a lowpass filter, if fp and fc represent the passband and stopband\n' ...
 'edge frequencies, respectively, these frequencies must satisfy the\n' ...
 'relation: 0 < fc < fp < fs/2.\n' ];

elseif ( strcmp(str,'ET-04') )

 s = [ ...
 'DFP-TYPE & SPECIFICATIONS CHECKING ERROR (Code ET-04):\n' ...
 '======================================================\n' ...
 'The passband and stopband attenuation parameters (expressed in dB)\n' ...
 'must be non-negative.\n' ];

elseif ( strcmp(str,'ET-05') )

 s = [ ...
 'DFP-TYPE & SPECIFICATIONS CHECKING ERROR (Code ET-05):\n' ...
 '======================================================\n' ...
 'Passband attenuation must be less than stopband attenuation.\n' ]; 

elseif ( strcmp(str,'ET-06') )

 s = [ ...
 'DFP-TYPE & SPECIFICATIONS CHECKING ERROR (Code ET-06):\n' ...
 '======================================================\n' ...
 'Acceptable values are 3 (for TYPE III) and 4 (for TYPE IV).\n'];

elseif ( strcmp(str,'ET-07') )

 s = [ ...
 'DFP-TYPE & SPECIFICATIONS CHECKING ERROR (Code ET-07):\n' ...
 '======================================================\n' ...
 'The peak error (expressed in dB) must be negative.  For example\n'...
 'for 1%% peak error set the relative error to -40 dB.\n' ];

elseif ( strcmp(str,'ET-08') )

 s = [ ...
 'DFP-TYPE & SPECIFICATIONS CHECKING ERROR (Code ET-08):\n' ...
 '======================================================\n' ...
 'The SLOPE parameter for the differentiator must be non-negative.\n'];

elseif ( strcmp(str,'ET-09') )

 s = [ ...
 'DFP-TYPE & SPECIFICATIONS CHECKING ERROR (Code ET-09):\n' ...
 '======================================================\n' ...
 'The differentiator cut-off frequency must satisfy fc <= (fs/2).\n'];

elseif ( strcmp(str,'WT-01') )

 s = [ ...
 'DFP-TYPE & SPECIFICATIONS CHECKING WARNING (Code WT-01):\n' ...
 '========================================================\n' ...
 'For TYPE III FIR filters, the cut-off frequency should be less than half\n'...
 'the sampling frequency.   Else, the peak relative error will become \n' ...
 'almost equal to the value of SLOPE since the design characteristics for\n'...
 'TYPE III FIR filters require that |H(fs/2)| = 0.\n' ];
 
elseif ( strcmp(str,'ET-10') )

 s = [ ...
 'DFP-TYPE & SPECIFICATIONS CHECKING ERROR (Code ET-10):\n' ...
 '======================================================\n' ...
 'The lower edge frequency, fl, must satisfy the strict inequality 0 < fl.\n'];

elseif ( strcmp(str,'ET-11') )

 s = [ ...
 'DFP-TYPE & SPECIFICATIONS CHECKING ERROR (Code ET-11):\n' ...
 '======================================================\n' ...
 'The upper edge frequency, fh, must satisfy the inequality fh <= fs/2.\n'];

elseif ( strcmp(str,'WT-02') )

 s = [ ...
 'DFP-TYPE & SPECIFICATIONS CHECKING WARNING (Code WT-02):\n' ...
 '========================================================\n' ...
 'For TYPE III FIR filters, the upper edge frequency should be less than\n'...
 '(fs/2).   Else, the peak error will become close to 1/2 as TYPE III\n'...
 'FIR filters require that |H(fs/2)| = 0.\n' ];

elseif ( strcmp(str,'ET-12') )

 s = [ ...
 'DFP-TYPE & SPECIFICATIONS CHECKING ERROR (Code ET-12):\n' ...
 '======================================================\n' ...
 'For a Hilbert Transformer the lower and upper edge frequencies must\n' ...
 'satisfy the inequality: 0 < fl < fs/4 < fh <= fs/2.\n' ];

elseif ( strcmp(str,'WT-03') )

 s = [ ...
 'DFP-TYPE & SPECIFICATIONS CHECKING WARNING (Code WT-03):\n' ...
 '========================================================\n' ...
 'For a Hilbert Transformer, the lower and upper edge frequencies\n' ...
 'should preferably be symmetric, such that fl = (fs/2-fh).\n' ...
 'Otherwise the peak error will be uneven over fl <= f <= fh.\n' ];

%============================
%  METHOD generated messages
%============================
%
%  WARNINGs
%===========
elseif ( strcmp(str,'WM-01') )

 s = [ ...
 'DFP-Method WARNING (Code WM-01):\n' ...
 '================================\n' ...
 'For "Window" based FIR design DfP uses the FIR1 function which designs\n' ...
 'TYPE I (even order) or II filters (odd order).  But for TYPE II filters\n' ...
 '|H(fs/2)|=0.   Therefore FIR1 does not design TYPE II filters in the\n' ...
 'highpass and bandstop cases.  For these cases filter order must be EVEN.\n'... 
 'Increasing user specified filter order from ' num2str(arg1) ' to ' ...
                                                num2str(arg2) '.\n' ]; 

elseif ( strcmp(str,'WM-02') )

 s = [ ...
 'DFP-Method WARNING (Code WM-02):\n' ...
 '================================\n' ...
 'Filter order must be a positive integer.  Rounding to the nearest\n' ...
 'integer value.\n' ];

elseif ( strcmp(str,'WM-03') )

 s = [ ...
 'DFP-Method WARNING (Code WM-03):\n' ...
 '================================\n' ...
 'For TYPE III FIR filters, the filter order must be EVEN.\n'... 
 'As a result of an odd valued user set filter order (' num2str(arg1) ')\n'...
 'the resulting filter will be a TYPE IV FIR filter.\n' ];

elseif ( strcmp(str,'WM-04') )

 s = [ ...
 'DFP-Method WARNING (Code WM-04):\n' ...
 '================================\n' ...
 'For TYPE IV FIR filters, the filter order must be ODD.\n'... 
 'As a result of an even valued user set filter order (' num2str(arg1) ')\n'...
 'the resulting filter will be a TYPE III FIR filter.\n' ];

elseif ( strcmp(str,'WM-05') )

 s = [ ...
 'DFP-Method WARNING (Code WM-05):\n' ...
 '================================\n' ...
 'For TYPE III FIR filters, the cut-off frequency should be less than half\n'...
 'the sampling frequency.   Else, the peak relative error will become \n' ...
 'almost equal to the value of SLOPE since the design characteristics for\n'...
 'TYPE III FIR filters require that |H(fs/2)| = 0.\n' ];

%
%  ERRORs
%===========

elseif ( strcmp(str,'EM-01') )

 s = [ ...
 'DFP-Method ERROR (Code EM-01):\n' ...
 '==============================\n' ...
 'You must select a filter design method by clicking on the radiobutton\n' ...
 'corresponding to your choice.\n' ];

elseif ( strcmp(str,'EM-02') )

 s = [ ...
 'DFP-Method ERROR (Code EM-02):\n' ...
 '==============================\n' ...
 'You have not selected a filter TYPE and/or have not SPECIFIED\n' ...
 'filter characteristics.  Please return to the TYPE/SPEC window\n' ...
 'and make a selection.\n' ];

elseif ( strcmp(str,'EM-03') )

 s = [ ...
 'DFP-Method ERROR (Code EM-03):\n' ...
 '==============================\n' ...
 'You must specify a positive integer as the filter order in the "ORDER\n' ...
 'SET" field for filter to be designed.   A good  starting point is the\n' ...
 'estimated filter order shown to the right of the "ORDER SET" field.\n' ];
 
elseif ( strcmp(str,'EM-04') )

 s = [ ...
 'DFP-Method ERROR (Code EM-04):\n' ...
 '==============================\n' ...
 'For REMEZ linear-phase FIR filter design method, the specified filter\n' ...
 'order must be 3 or more.\n' ];
 
%=============
%  QUANTIZER 
%=============
%
%  WARNINGs
%=============
elseif ( strcmp(str,'WQU-01') )

 if ( strcmp(arg3,'twoscomp') )
    range = [ '[-' num2str(2^arg2) ', ' num2str(2^arg2) ')' ];
 else
    range = [ '[0, ' num2str(2^arg2) ')' ];
 end
 if ( arg1 > 1 )
    nostr = 'coefficients have';
 else
    nostr = 'coefficient has';
 end
 s = [ ...
 'DFP-Quantize WARNING (Code WQU-01):\n' ...
 '===================================\n' ...
 'Quantizer saturation.  In quantizing filter coefficients, ' ...
                                                     num2str(arg1) '\n' ...
  nostr ' exceeded the quantizer range ' range '.\n' ];

%
%  ERRORs
%=============
elseif( strcmp(str,'EQU-01') )

 s = [ ...
 'DFP-Quantize ERROR (Code EQU-01):\n' ...
 '=================================\n' ...
 'You must enter a valid number in the NUMBER OF BITS field.\n' ];

elseif( strcmp(str,'EQU-02') )

 s = [ ...
 'DFP-Quantize ERROR (Code EQU-02):\n' ...
 '=================================\n' ...
 'You must enter a valid number in the INTEGER BITS field.\n' ];

elseif( strcmp(str,'EQU-03') )

 s = [ ...
 'DFP-Quantize ERROR (Code EQU-03):\n' ...
 '=================================\n' ...
 'The numbers entered for NUMBER Of BITS and INTEGER BITS must be \n' ...
 'positive integers, such that 0 <= INTEGER BITS <= NUMBER OF BITS.' ];

%=============
%  PROPERTIES 
%=============
%
%  WARNINGs
%=============
elseif ( strcmp(str,'WP-01') )

 s = [ ...
 'DFP-Properties WARNING (Code WP-01):\n' ...
 '====================================\n' ...
 'Cannot open DFPRC, will use global default values.  Possible causes\n'...
 'may be that the user set-up file "dfprc.m" does not exist, or it is\n'...
 'not located in MATLAB path.\n' ];

%
%  ERRORs
%=============
elseif ( strcmp(str,'EP-01') )

 s = [ ...
 'DFP-Properties ERROR (Code EP-01):\n' ...
 '==================================\n' ...
 'The system global variables default file DFPRCDEF cannot be found.\n' ...
 'Cannot restore default values.\n' ];

elseif ( strcmp(str,'EP-02') )

 s = [ ...
 'DFP-Properties ERROR (Code EP-02):\n' ...
 '==================================\n' ...
 'RGB values must be between 0 and 1.\n' ...
 'Please check the string "' arg1 '" entered into the "Other..."\n' ...
 'color field for correctness.\n' ];

elseif ( strcmp(str,'EP-03') )

 s = [ ...
 'DFP-Properties ERROR (Code EP-03):\n' ...
 '==================================\n' ...
 'The number of frequency response points must be a positive integer.\n' ...
 'Please check the string "' arg1 '" for correctness.\n' ];

%=======================================
%  GENERAL messages
%=======================================

elseif ( strcmp(str,'EG-01') )

 arg1 = strrep(arg1,'\','\\'); 
 s = [ ...
 'DFP-General ERROR (Code EG-01):\n' ...
 '===============================\n' ...
 'Invalid directory name:\n\n' '\t' arg1 '\n' ];
 
elseif ( strcmp(str,'EG-02') )

 arg1 = strrep(arg1,'\','\\'); 
 arg2 = strrep(arg2,'\','\\'); 
 s = [ ...
 'DFP-General ERROR (Code EG-02):\n' ...
 '===============================\n' ...
 'Invalid file name or an error has occured in working with the file:\n\n\t'...
  arg1 '\n\nin the directory:\n\n\t' arg2 ...];
 '\n\nPlease check the file name.\n' ];
 
elseif ( strcmp(str,'EG-03') )

 arg1 = strrep(arg1,'\','\\'); 
 s = [ ...
 'DFP-General ERROR (Code EG-03):\n' ...
 '===============================\n' ...
 'Cannot open the file\n\n\t' arg1 ...
 '\n\nPlease check the path and file names.\n' ];

elseif ( strcmp(str,'EG-04') )

 arg1 = strrep(arg1,'\','\\'); 
 s = [ ...
 'DFP-General ERROR (Code EG-04):\n' ...
 '===============================\n' ...
 'Cannot close the file\n\n\t' arg1 '\n\n'];

elseif ( strcmp(str,'EG-05') )

 s = [ ...
 'DFP-General ERROR (Code EG-05):\n' ...
 '===============================\n' ...
 'Directory names must be terminated by a proper file separator.\n' ...
 'For example, on UNIX systems enter a directory name such as\n'    ... 
 '"/home/usr/matlab/".\n' ];

elseif ( strcmp(str,'EG-06') )

 arg1 = strrep(arg1,'\','\\'); 
 arg2 = strrep(arg2,'\','\\'); 
 s = [ ...
 'DFP-General ERROR (Code EG-06):\n' ...
 '===============================\n' ...
 'The file:\n\n\t' arg2 arg1 ...
 '\n\ncannot be found.  Please check the file name.\n' ];
 
elseif ( strcmp(str,'EG-07') )

 s = [ ...
 'DFP-General ERROR (Code EG-07):\n' ...
 '===============================\n' ...
 'The user entered data must be a positive integer.\n' ];
 
elseif ( strcmp(str,'WG-01') )

 s = [ ...
 'DFP-General WARNING (Code WG-01):\n' ...
 '=================================\n' ...
 'You must specify a file name.\n' ];
 
end

fprintf( [ '\n\07' s '\n'] );
