function d_dplydr( arg1, arg2 )
%DFP_DPLYDR is a utility function which updates the magnitude, 
%      phase/group-delay/impulse response plots in the "DISPLAY" window.
%
%      DFP_DPLYDR( ARG_1, ARG_2 ):
%      ARG_1 = [ a b c ] such that
%                a --> 0/1 (do not)/(update) magnitude plot
%                b --> 0/1/2/3 (do not)/(update) secondary plot any/P/Gd/I
%                      NaN determine secondary plot to be updated (P/Gd/I)
%                      from the pop-up menu in the "DFP Navigator" window
%                c --> 0/1 (do not)/(update) pole-zero plot
%      If ARG_1(2) = 2,3, then ARG_2 = N, where N represents the number of 
%      points used to evaluate the Group Delay or the Impulse Response plot.
%      If ARG_1(2) = 1, then Phase plot is to be evaluated and ARG_2 = [d e]
%      such that
%                 d --> 0/1 phase wrap/unwrap
%                      NaN determine wrap/unwrap from the pop-up menu in the
%                      "DFP Display" window
%                 e --> 0/1 phase radians/degree
%                      NaN determine rad/deg from the pop-up menu in the
%                      "DFP Display" window

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

%==================
%  GLOBAL variables
%==================
global DFP_FREQZpoints  DFP_GRPDELAYpoints DFP_IMPULSEpoints  ...
       DFP_MAGcolor     DFP_PHASEcolor                        ...
       DFP_POLEcolor    DFP_ZEROcolor      DFP_POLEZEROaxis   ...
       DFP_bbQ          DFP_aaQ            DFP_fs


FIG4han = findobj( get(0,'Children'), 'flat', 'Tag', 'fig4' );
CHLDhan = get( FIG4han, 'Children');

MAGNITUDEflag = 0;
SECONDARYflag = 0;
POLEZEROflag  = 0;

if ( arg1(1) == 1 )
   MAGNITUDEflag = 1;
end
if ( isnan(arg1(2)) )
   SECONDARYaction = ...
      get( ...
           findobj(get(findobj(get(0,'Children'),'flat','Tag','fig1'), ...
          'Children'), 'Style','popupmenu','Userdata','fig1:popup'), ...
          'Value');
   SECONDARYflag = 1;
else
   if ( arg1(2) == 0 )
      SECONDARYflag = 0;
   else
      SECONDARYflag = 1;
      SECONDARYaction = arg1(2);
   end
end
if ( arg1(3) == 1 )   
   POLEZEROflag = 1;
end

[H,f] = freqz( DFP_bbQ , DFP_aaQ, DFP_FREQZpoints, DFP_fs ); 
y     = angle(H);

if ( SECONDARYflag )
      
   PHASEMENUhan  = findobj( CHLDhan, 'flat', 'Tag', 'menu4:phase' );
   NUMBERMENUhan = findobj( CHLDhan, 'flat', 'Tag', 'menu4:points');

   if ( SECONDARYaction == 1 )

      RADhan    = findobj( get(PHASEMENUhan,'Children'), 'flat', ...
                           'Type','uimenu', 'Tag', 'menu4:rad');
      DEGhan    = findobj( get(PHASEMENUhan,'Children'), 'flat', ...
                           'Type','uimenu', 'Tag', 'menu4:deg');
      WRAPhan   = findobj( get(PHASEMENUhan,'Children'), 'flat', ...
                           'Type','uimenu', 'Tag', 'menu4:wrap');
      UNWRAPhan = findobj( get(PHASEMENUhan,'Children'), 'flat', ...
                           'Type','uimenu', 'Tag', 'menu4:unwrap');
    
      if ( nargin == 1 )
         PHASEarg = [ NaN NaN ];
      else
         PHASEarg = arg2;
      end
      if ( isnan(PHASEarg(1)) )
         handle = findobj( WRAPhan, 'Checked', 'on' );
         WRAP = ~isempty(handle);
      else
         WRAP = PHASEarg(1);
      end
      if ( isnan(PHASEarg(2)) )
         handle = findobj( RADhan, 'Checked', 'on' );  
         RAD = ~isempty(handle);
      else
         RAD = PHASEarg(2);
      end

      if ( WRAP )
         set( WRAPhan,   'Checked', 'on' );
         set( UNWRAPhan, 'Checked', 'off' );
      else
         set( WRAPhan,   'Checked', 'off' );
         set( UNWRAPhan, 'Checked', 'on' );
         y = unwrap(y);
      end
      if ( RAD )
         set( RADhan, 'Checked', 'on' );
         set( DEGhan, 'Checked', 'off' );
         y = y/pi;
         FontName = 'symbol';
         YLABELtext = 'f/p';
      else
         set( RADhan, 'Checked', 'off' );
         set( DEGhan, 'Checked', 'on' );
         y = (y/pi)*180;
         FontName = 'helvetica';
         YLABELtext = '[deg]';
      end
      PHASEMENUvisible = 'on';
      NUMBERMENUvisible = 'off';
      LABELstr = 'Phase  ';
      x = f;
      XLABELtext = 'Frequency [Hz]';
      Xlim = [ 0 DFP_fs/2];

   elseif ( SECONDARYaction == 2 )

      if ( nargin == 1 )
         NOpoints = DFP_GRPDELAYpoints;
      else
         NOpoints = arg2;
      end
      [y,x] = grpdelay( DFP_bbQ, DFP_aaQ, NOpoints, DFP_fs );
      YLABELtext = 'Samples';
      XLABELtext = 'Frequency [Hz]';
      Xlim = [ 0 DFP_fs/2];
      LABELstr = 'Group Delay  ';
      MENUstr  = 'Gdelay';
      MENUacc  = 'G';
      PHASEMENUvisible = 'off';
      NUMBERMENUvisible = 'on';
      FontName = 'helvetica';

   elseif ( SECONDARYaction == 3 )   % ===== Impulse Response =====

      if ( nargin == 1 )
         NOpoints = DFP_IMPULSEpoints;
      else
         NOpoints = arg2;
      end
      [y,x] = impz( DFP_bbQ, DFP_aaQ, NOpoints, DFP_fs );
      YLABELtext = '';
      XLABELtext = 'Time [sec]';
      Xlim = [min(x) max(x)];
      LABELstr = 'Impulse  ';
      MENUstr  = 'Impulse';
      MENUacc  = 'I';
      PHASEMENUvisible = 'off';
      NUMBERMENUvisible = 'on';
      FontName = 'helvetica';

   end

end

set( FIG4han, 'Nextplot', 'add' );
set( findobj(CHLDhan,'flat','Type','axes'), 'Nextplot', 'replace' );


if ( MAGNITUDEflag )

   AXEShan    = findobj( CHLDhan, 'flat', 'Type', 'axes', 'Tag', 'axes:mag' );
   MAGplothan = findobj( AXEShan, 'Tag',  'plot:mag' );
   if( ~isempty(MAGplothan) ); delete(MAGplothan); end
   axes( AXEShan );
   H = abs(H);
   line( f,  H,                                          ...
                            'Color',      DFP_MAGcolor,  ...
                            'Visible',   'off',          ...
                            'LineStyle', '-',            ...
                            'Userdata',   0,             ...
                            'Erasemode', 'normal',       ...
                            'Tag',       'plot:mag'         );
   if ( ~all(H) )
      H(H==0) = NaN * ones( size(H(H==0)) );
   end
   line( f, 20*log10(H),                                 ...
                            'Color',      DFP_MAGcolor , ...
                            'Visible',   'off',          ...
                            'LineStyle', '-',            ...
                            'Userdata',   1,             ...
                            'Erasemode', 'normal',       ...
                            'Tag',       'plot:mag'         );
end

if ( SECONDARYflag )

   AXEShan = findobj( CHLDhan, 'flat', 'Type', 'axes', 'Tag', 'axes:pha' );
   axes( AXEShan );
   xgrid = get( AXEShan, 'Xgrid' );
   ygrid = get( AXEShan, 'Ygrid' );
   plot( x, y,    ...
                            'Color',       DFP_PHASEcolor, ...
                            'Erasemode',  'normal' ,       ... 
                            'Tag',        'plot:pha'          ); 
   ylabel( YLABELtext, 'FontName', FontName ); 
   xlabel( XLABELtext );
   set( AXEShan, 'Xlim', Xlim, 'Xgrid', xgrid, 'Ygrid', ygrid );

   set( PHASEMENUhan, 'Visible', PHASEMENUvisible );
   set( NUMBERMENUhan, 'Visible', NUMBERMENUvisible);
   set( findobj(FIG4han,'Type', 'uimenu', 'Tag', 'snp:secondary'), ...
        'Label', LABELstr );
   if ( SECONDARYaction ~= 1 )
      set( NUMBERMENUhan, 'Label', MENUstr, 'Accelerator', MENUacc );
      ch = get( NUMBERMENUhan,'children');
      gr = findobj( ch, 'flat', 'Tag', 'menu4:grid2' );
      ch = ch(ch~=gr);
      set( ch, 'Checked', 'off' )
      set( findobj(ch,'flat','Type','uimenu','Userdata',NOpoints), ...
           'Checked','on');
   end

end

if ( POLEZEROflag )

   a = DFP_aaQ;
   if(length(a)==1); a=zeros(size(DFP_bbQ)); a(1)=1; end
   AXEShan = findobj( CHLDhan, 'flat', 'Type', 'axes', 'Tag', 'axes:poz' );
   PLOThan = findobj( AXEShan, 'Tag',  'plot:poz' );
   if( ~isempty(PLOThan) ); delete(PLOThan); end
   axes(AXEShan);
   [hz,hp,ht]=zplane(DFP_bbQ,a);
   set( hz, 'Color', DFP_ZEROcolor,    'Tag', 'plot:poz' );
   set( hp, 'Color', DFP_POLEcolor,    'Tag', 'plot:poz' );
   set( ht, 'Color', DFP_POLEZEROaxis, 'Tag', 'plot:poz' );
   xlabel(''); ylabel('');

end

set( findobj(CHLDhan,'flat','Type','axes'), 'Nextplot', 'new' );
set( FIG4han, 'Nextplot', 'new' );

d_navgcb(2);
