function d_csldcb( Action )
%D_CSLDCB callback function for the sliders in the coefficient DISPLAY window.
%
%        D_CSLDCB reads the current value of the specified slider then 
%        determines which portion of the coefficient string array will
%        be visible, attaches the appropriate array labels to this array with
%        the appropriate index numbers and sets the "string" property of the
%        editable text object to this string array.   The number of lines
%        that can be displayed at one time is specified by the global variable
%        "DFP_scrolltextlines" which has been determined as the DISPLAY window 
%        was created and communicated to this m-file as a global variable.
%        This allows the "DFP_scrolltextlines" to be determined as a function
%        of the DISPLAY window size.   
%
%        D_CSLDCB( ACTION ) specifies to D_CSLDCB what type of ACTION by which
%        slider object is required.   In particular,
%        ACTION = 1 --> top editable text window slider callback
%                 2 --> bottom editable text window slider callback IF
%                       both top and bottom windows (such as in polynomial
%                       format) are visible.
%                 3 --> only the bottom window is visible and the string 
%                       has to be formatted for a SOS system.
%                 4 --> only the bottom window is visible and the string has
%                       to be formatted for an FIR Lattice filter. 

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

%====================
%  GLOBAL variables
%====================
global DFP_top            DFP_bottom        ...
       DFP_topsymbol      DFP_bottomsymbol  ...
       DFP_topstr         DFP_bottomstr     ...
       DFP_scrolltextlines

MM = size(DFP_top,2);
NN = size(DFP_bottom,2);

CHLDhan = get(findobj(get(0,'Children'),'flat','Tag','fig4'),'Children');

if ( Action == 1 )

   SLhan   = findobj( CHLDhan, 'flat', 'Style','slider','Tag','slider:top');
   MMstart = fix( get(SLhan,'Value') );
   idx     = MMstart:limiter(MMstart+DFP_scrolltextlines,1,MM);
   str     = [];
   for ii = 1:length(idx)
       str = str2mat( str, ...
                      sprintf('%s(%i) = %s', ...
                      DFP_topsymbol,idx(ii),DFP_topstr(idx(ii),:)) ...
                    );
   end
   str = str(2:size(str,1),:);
   Handle  = findobj( CHLDhan, 'flat', 'Style','edit','Tag','scroll:top');

elseif ( Action == 2 )

   SLhan   = findobj( CHLDhan, 'flat', 'Style','slider','Tag','slider:bottom');
   NNstart = fix( get(SLhan,'Value') );
   idx     = NNstart:limiter(NNstart+DFP_scrolltextlines,1,NN);
   str     = [];
   for ii = 1:length(idx)
       str = str2mat( str, ...
                      sprintf('%s(%i) = %s', ...
                      DFP_bottomsymbol,idx(ii),DFP_bottomstr(idx(ii),:)) ...
                    );
   end
   str = str(2:size(str,1),:);
   Handle  = findobj( CHLDhan, 'flat', 'Style','edit','Tag','scroll:bottom');

elseif ( Action == 3 )

   SLhan   = findobj( CHLDhan, 'flat', 'Style','slider','Tag','slider:bottom');
   NNstart = fix( get(SLhan,'Value') );
   NNstop  = limiter(NNstart+1,1,size(DFP_bottom,1));
   str     = [];
   for ii = NNstart:NNstop
       str = str2mat( str, sprintf(' ___ Section %i ________',ii) );...
       for jj = 1:3
           str = str2mat( str, ...
                          sprintf(' b(%i,%i) = %s', ...
                          ii,jj,DFP_bottomstr((ii-1)*6+jj,:)) ...
                        );
       end
       for jj = 4:6
           str = str2mat( str, ...
                          sprintf(' a(%i,%i) = %s', ...
                          ii,(jj-3),DFP_bottomstr((ii-1)*6+jj,:)) ...
                        );
       end
   end
   str = str(2:size(str,1),:);
   Handle  = findobj( CHLDhan, 'flat', 'Style','edit','Tag','scroll:bottom');

elseif ( Action == 4 )

   SLhan   = findobj( CHLDhan, 'flat', 'Style','slider','Tag','slider:bottom');
   NNstart = fix( get(SLhan,'Value') );
   idx     = NNstart:limiter(NNstart+3*DFP_scrolltextlines,1,NN);
   str     = [];
   for ii = 1:length(idx)
       str = str2mat( str, ...
                      sprintf('%s(%i) = %s', ...
                      DFP_bottomsymbol,idx(ii),DFP_bottomstr(idx(ii),:)) ...
                    );
   end
   str = str(2:size(str,1),:);
   Handle  = findobj( CHLDhan, 'flat', 'Style','edit','Tag','scroll:bottom');

end

set(Handle,'String',str);
