function  d_cfmtcb( Action )
%D_CFMTCB generates the string arrays to be displayed in the editable text
%         windows of the DISPLAY window under the user specified format.
%
%         D_CFMTCB( FORMAT ) gets the global data arrays "DFP_top" and
%         "DFP_bottom" and generates the globally accessible string arrays
%         "DFP_topstr" and "DFP_bottomstr" (which contain only the string 
%         versions of the numeric values) based on the specified FORMAT.
%         It then calls D_CSLDCB for the visible editable text windows.
%         The reason why this function does not add the {a(1),b(1),... labels
%         is the keep the numeric values separate, as only these numeric
%         change under the FORMAT control.
%         FORMAT = 0 --> string array in floating point
%                  1 --> hexadecimal
%                  2 --> octal
%                  3 --> binary
%         This is the main function through which the Coefficient/Menu 
%         callbacks in the DISPLAY window are implemented.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

%==================
%  GLOBAL variables
%==================
global  DFP_top      DFP_bottom     DFP_fir  ...
        DFP_topstr   DFP_bottomstr

%==================
%  OBJECT handles
%==================
MNhan    = sort(findobj(findobj(get(0,'Children'),'flat','Tag','fig4'), ...
                'Tag','format:coeff'));
CHLDhan  =  get(findobj(get(0,'Children'),'flat','Tag','fig5'),'Children');
RB1han   = sort(findobj(CHLDhan,'flat','Style','radiobutton','Tag','fixed'));
RB2han   = sort(findobj(CHLDhan,'flat','Style','radiobutton','Tag','format'));
EThan    = sort(findobj(CHLDhan,'flat','Style','edit'));

set( MNhan,'Checked','off' ); set( MNhan(Action+1),'Checked','on');

%======================================= 
%  INPUT_FORMAT = [ 2sComp Ntotal Nint ]
%======================================= 
input_format = [ get(RB1han(1),'Value')          ...
                 str2num(get(EThan(1),'String')) ...
                 str2num(get(EThan(2),'String'))     ];

if ( Action == 0 )  %==== FLOAT ====
   input_format = 2;
end

output_format = Action;

if ( ~isnan(DFP_top) ) 
   DFP_topstr = d_format( DFP_top,    input_format, output_format );
end
DFP_bottomstr = d_format( DFP_bottom, input_format, output_format );

if ( get(RB2han(3),'Value') )    %== special case if Format==SoS
   d_csldcb(3);
elseif ( get(RB2han(2),'Value') & DFP_fir )  %== special case Format==Lattice
   d_csldcb(4);
else
   d_csldcb(1);
   d_csldcb(2);
end
