function d_append(Fid0,FileToBeAppended)
%D_APPEND appends one file to another.
%
%        D_APPEND(FID,'filename') opens the file 'filename' and
%        appends its contents to the file with file identifier
%        FID from the current position.  
%
%        The file with identifier FID must have previously been 
%        opened for writing.  Otherwise an error condition will 
%        be generated.
%
%        At the end of the append operation 'filename' is closed.
%
%        Example :    d_append( opened_file_id, 'append_this_file');
%        will append the content of the file 'append_this_file'
%        to the file descriptor opened_file_id, which is the 
%        file already opened before entering this function.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%  $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%


fid = fopen(FileToBeAppended,'r');% Open file for reading
if ( fid == -1 )
   d_error( 'EO-06', FileToBeAppended );
   return;
end

while(1)    % Append one file to another
   s = fgets(fid);
   if ( feof(fid) == 0 )
      wr_status = fprintf(Fid0 ,'%s',s);  % Write to file  
      if ( wr_status == 0 )
         %fprintf('FAPPEND: Unable to write to file %s.\n',fopen(Fid0));
         return;
      end
   elseif ( feof(fid) == 1 )
      fclose(fid );
      return;
   end
end
