function d_almncb( Action )
%D_ALMNCB controls the axis limits menu callback in the DISPLAY window.
%
%         D_ALMNCB( AXES ) sets up the axis limits dialog box for the
%         AXES, where: AXES = 1,   Magnitude axes;
%                             2,   Phase axes;
%                             3,   Group Delay or Impulse Response axes. 
%         The axis limits dialog box is generated by the function D_AXLDLG
%         which has been taken and modified from the Mathworks function
%         AXLIMDLG.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

if ( Action == 1 )

   % DlgName = 'DFP: Magnitude Axes';
   DlgName = d_namesv(10);
   PromptStr = str2mat( 'Frequency:', 'Magnitude:' );
   AxesHan   = findobj(get(findobj(get(0,'Children'),'flat','Tag','fig4'), ...
               'Children'),'flat','Type','axes','Tag','axes:mag'); 

elseif ( Action == 2 )

   % DlgName = 'DFP: Phase Axes';
   DlgName = d_namesv(11);
   PromptStr = str2mat( 'Frequency:', 'Phase:' );
   AxesHan   = findobj(get(findobj(get(0,'Children'),'flat','Tag','fig4'), ...
               'Children'),'flat','Type','axes','Tag','axes:pha'); 

elseif ( Action == 3 )

   Value = get(findobj(get(findobj(get(0,'Children'),'flat','Tag','fig1'), ...
           'Children'),'flat','Type','uicontrol','Style','popupmenu'),'Value');
   if ( Value == 2 )
      % DlgName = 'DFP: Group Delay';
      DlgName = d_namesv(12);
      PromptStr = str2mat( 'Frequency:', 'Samples:' );
   elseif ( Value == 3 )
      % DlgName = 'DFP: Impulse Response';
      DlgName = d_namesv(13);
      PromptStr = str2mat( 'Time:', 'h(n):' );
   end

   AxesHan   = findobj(get(findobj(get(0,'Children'),'flat','Tag','fig4'), ...
               'Children'),'flat','Type','axes','Tag','axes:pha'); 

end

d_axldlg( DlgName, [0 0], PromptStr, [AxesHan NaN AxesHan] );
