
       org   p:$0
       jmp   start

       org   p:ProgramAddress

;*************************************************************
; Initialization and set up SSI
;*************************************************************

start

       ori   #$8,mr             ; set accumulator to scale up 
       aiset                    ; set-up the SSI port


;********************************************************
; Read ADC
;********************************************************
; The following code polls the RDF flag in the SSI-SR and
; waits for RDF=1 and then reads the RX register to
; retrieve the data from the A/D converter
;********************************************************

wait2

;*************************************************************
; receive data from ADC
;*************************************************************

wait1  jclr   #7,x:ssi_sr,wait1  ; wait for the ADC data
       movep  x:ssi_rx,x0        ; put ADC value into X0

      ;****************
      ;   IIR Filter
      ;****************

      move  #state,r0           ; r0 points to state
      move  #coeff,r4           ; r4 points to coefficients
      move  #igain,y1
      mpy   y1,x0,a  x:(r0)+,x0  y:(r4)+,y0 
                                ; put current state in Accumulator
                                ; load a(1,3) into y0
                                ; load w[n-2] into x0  
                                ; r0 points to w1[n-1]

      do    #biquad,mloop
      mac   x0,y0,a  x:(r0)-,x1  y:(r4)+,y0
                                ; y0 now contains a(1,2)
                                ; x1 now contains w[n-1]
                                ; r0 points to w[n-2]

      macr  x1,y0,a  x1,x:(r0)+  y:(r4)+,y0
                                ; w[n-1] is placed in w[n-2], 
                                ; but x0 still holds w[n-2]
                                ; r0 points to w[n-1]

      mpy   y0,x0,a  a,x:(r0)+  a,y1
                                ; a=b(1,3)*w[n-2]
                                ; store w[n] in w[n-1] for next stage
                                ; y1= w[n]

      move  y:(r4)+,y0      
                                ; y0=b(1,2)

      mac   x1,y0,a  y:(r4)+,y0           
                                ; a=b(1,3)w[n-2]+b(1,2)w[n-1],   
                                ; y0 now contains b(1,1)

      macr  y1,y0,a  y:(r4)+,y0  x:(r0)+,x0
                                ; a=b(1,1)w[n]+b(1,2)w[n-1]+b(1,3)w[n-2]
                                ; a contains input to next biquad
                                ; y0 contains a(2,3) of next biquad
                                ; x0 contains w[n-2] of next biquad
                                ; r0 points to w[n-1] of next biquad

mloop
      
;*******************************************************
; Write output data to the DAC
;*******************************************************

      movep  a,x:ssi_tx          ; output the result to the DAC

      jmp    wait2

      end

