

       org   p:$0
       jmp   start

       org   p:ProgramAddress

;*************************************************************
; Initialization and set up SSI
;*************************************************************

start

       aiset                    ; set-up the SSI port

;*************************************************************
;  Set up the registers
;*************************************************************

       move   #state,r0         ; point to filter state
       move   #order,m0         ; set modulo for R0
       move   #coeff,r4         ; point to filter coefficients
       move   #order*2,m4       ; set modulo for R4

       clr    b                 

wait2 

;*************************************************************
; receive data from ADC
;*************************************************************

wait1  jclr   #7,y:ssi_sr,wait1  ; wait for the ADC data
       movep  x:ssi_rx,a         ; put ADC value into x0

       ;*********************
       ;  IIR Lattice Filter
       ;*********************

       move           x:(r0)-,x0  y:(r4)+,y0     ;get first k, first s

       do    #order,_endlat                      ;calculate states
       macr  -y0,x0,a             b,x:(r0)+      ;a-k*s, save prev s
       move            a,y1       x:(r0)+,b      ;set a for mul, s again 
       macr  y1,y0,b  x:(r0)-,x0  y:(r4)+,y0     ;a*k+s, k, nxt s
_endlat

       move                       b,x:(r0)+      ;sv scnd to 1st st
       clr   a                    a,x:(r0)+      ;save first state
       move                       x:(r0)+,x0     ;get last state

       rep   #order
       mac   x0,y0,a  x:(r0)+,x0  y:(r4)+,y0     ;do fir taps
       macr  x0,y0,a              (r0)+          ;mac and round, adj pointer

;*******************************************************
; Write output data to the DAC
;*******************************************************

       movep  a,x:ssi_tx         ; output the result to the DAC

       jmp    wait2

       end

