
       org   p:$0
       jmp   start

       org   p:ProgramAddress

;********************************************************
; Initialization and set up SSI
;********************************************************

start

       ori   #$8,mr          ; set accumulator to scale up 
       aiset                 ; set-up the SSI port

       move  #state,r0       ; point to filter states
       move  #nstate-1,m0    ; mod (nstate)
       move  #coeff,r4       ; point to filter coefficients
       move  #2*nstate-2,m4  ; mod (2*nstate-1)

;********************************************************
; Read ADC
;********************************************************
; The following code polls the RDF flag in the SSI-SR and
; waits for RDF=1 and then reads the RX register to
; retrieve the data from the A/D converter
;********************************************************

wait2 

;********************************************************
; receive data from ADC
;********************************************************

wait1  jclr   #7,x:ssi_sr,wait1               ; wait for the ADC data
       movep  x:ssi_rx,x0                     ; put ADC value into X0

      ;****************
      ;   Filter
      ;****************

      move  #igain,y1                         ; Scale factor used for x[n]

      mpy   y1,x0,a  x:(r0)+,x0  y:(r4)+,y0   ; A =x[n]/2, Y0=a(2), R4->a(3)
                                              ; X0=w[n-1], R0->w[n-2]
      ;**************
      ;  IIR part
      ;**************
      rep   #nstate-2                         
      mac   x0,y0,a  x:(r0)+,x0  y:(r4)+,y0
      macr  x0,y0,a              y:(r4)+,y0   ; A =w[n], R0->w[n-N]
                                              ; Y0=b(1), R4->b(2) 

      move           a,x:(r0)+                ; R0 -> w[n-1]
      move           a,x0                     ; X0 = w[n]
      mpy   x0,y0,a  x:(r0)+,x0  y:(r4)+,y0   ; A=b(1)w[n],X0=w[n-1],R0->w[n-2]
                                              ;            Y0=b(2),  R4->b(3)
      ;**************
      ;  FIR part
      ;**************
      rep   #nstate-2
      mac   x0,y0,a  x:(r0)+,x0  y:(r4)+,y0   
      macr  x0,y0,a                           ; A=y[n]

;*******************************************************
; Write output data to the DAC
;*******************************************************

      movep  a,x:ssi_tx                       ; output y[n] to the DAC

      jmp    wait2

      end

