
       org   p:$0
       jmp   start

       org   p:ProgramAddress

;*************************************************************
; Initialization and set up SSI
;*************************************************************

start

       aiset                    ; set-up the SSI port

;*************************************************************
;  Set up the registers
;*************************************************************

       move   #state,r0         ; point to filter state
       move   #ncoef,m0         ; set modulo for R0
       move   #coeff,r4         ; point to filter coefficients
       move   #ncoef,m4         ; set modulo for R4

wait2 

;*************************************************************
; receive data from ADC
;*************************************************************

wait1  jclr   #7,x:ssi_sr,wait1  ; wait for the ADC data
       movep  x:ssi_rx,x0        ; put ADC value into X0

       ;*********************
       ;  FIR Lattice Filter
       ;*********************

       move             x0,b
       move             b,x:(r0)+    y:(r4)+,y0  ;save B as 1st st., mv fst k

       do     #ncoef,_endlat

       move             x:(r0),a     b,y1        ;get state, set t for mul by k
       macr   y1,y0,a   a,x1                     ;t*k+s, copy s
       macr   x1,y0,b   a,x:(r0)+    y:(r4)+,y0  ;s*k+t, sv st., nxt k

_endlat

       move   #GainF,y0
       mpy    x0,y0,a   b,x1      ; a=x[n]*GainF  b=Lattice o/p
       move   #GainL,y1
       mac    x1,y1,a             ; a=(GainF/2)*x[n] + (GainL/2)*Lattice o/p
       asl    a         (r0)-     ; a=2*a=y[n] and adjust pointer
       move             a,x0      ; move y[n] to x0 to be sent to the DAC   

;*******************************************************
; Write output data to the DAC
;*******************************************************

       movep  x0,x:ssi_tx         ; output the result to the DAC

       jmp    wait2

       end

