
       org   p:$0
       jmp   start

       org   p:ProgramAddress

;*************************************************************
; Initialization and set up SSI
;*************************************************************

start

       aiset                    ; set-up the SSI port
 
;*************************************************************
;  Set up the registers
;*************************************************************

       move   #state,r0         ; point to filter state
       move   #ntaps-1,m0       ; set modulo for R0
       move   #coeff,r4         ; point to filter coefficients
       move   #ntaps-1,m4       ; set modulo for R4


wait2 

;*************************************************************
; receive data from ADC
;*************************************************************

wait1  jclr   #7,x:ssi_sr,wait1  ; wait for the ADC data
       movep  x:ssi_rx,x0        ; put ADC value into X0

       ;**************
       ;  FIR Filter
       ;**************

       clr    a          y:(r4)+,y0  x0,x:(r0)+
                                 ; clear the accumulator
                                 ; store state on top
       rep    #ntaps-1
       mac    x0,y0,a   x:(r0)+,x0   y:(r4)+,y0
       macr   x0,y0,a   (r0)-    

;*******************************************************
; Write output data to the DAC
;*******************************************************

       movep  a,x:ssi_tx          ; output the result to the DAC

       jmp    wait2
       
       end

