;**************************************************
;                                                  
; Created by     : Digital Filter Package (DFP)        
;                  Version  1.0  
;                                                  
; Created on     : 25-Feb-1997, 10:50  
;                                                  
;--------------------------------------------------
;                                                  
; Filter Type    : Low Pass  
;                                                  
;     Sampling Frequency =  48000 
;     Passband Edge =  12000 
;     Passband Attenuation (dB) =  4 
;     Stopband Edge =  15000 
;     Stopband Attenuation (dB) =  50 
;                                                  
; Design Method  : IIR/ChebyII  
; Implementation : SOS  
; Coefficients   : [24,1,t]  
;                                                  
;**************************************************

  INCLUDE 'aiset.asm'

;***********************************************************************
;
; IIR Filter Code
; Cascade of Biquad Sections with Scaling
;
; For further information about this implementation for the Motorola
; DSP56k family of fixed point DSPs please see the help file:
;  
;     iir_sos.hlp
;
; $Revision: 1.2 $   $Date: 1997/02/25 15:24:19 $   $Author: mzeytin $
;
;**********************************************************************

ssi_rx             equ   $ffef       ; SSI port receive register
ssi_tx             equ   $ffef       ; SSI port transmit register
ssi_sr             equ   $ffee       ; SSI port status register


igain              equ  0.5 
CoeffArrayAddress  equ  $0
StateArrayAddress  equ  $0
ProgramAddress     equ  $100
biquad             equ  4

      org  Y:CoeffArrayAddress  
                                 ;=== Biquad 1 ===
coeff dc   0.00000000000000      ; -a(1,3)/2
      dc   -0.07400465011597     ; -a(1,2)/2
      dc   0.00000000000000      ;  b(1,3)/2
      dc   0.28700232505798      ;  b(1,2)/2
      dc   0.28700232505798      ;  b(1,1)/2
                        
                                 ;=== Biquad 2 ===
      dc   -0.05136477947235     ; -a(2,3)/2
      dc   -0.11959135532379     ; -a(2,2)/2
      dc   0.18329501152039      ;  b(2,3)/2
      dc   0.30436623096466      ;  b(2,2)/2
      dc   0.18329501152039      ;  b(2,1)/2
                        
                                 ;=== Biquad 3 ===
      dc   -0.16678905487061     ; -a(3,3)/2
      dc   -0.05332374572754     ; -a(3,2)/2
      dc   0.23423850536346      ;  b(3,3)/2
      dc   0.25163578987122      ;  b(3,2)/2
      dc   0.23423850536346      ;  b(3,1)/2
                        
                                 ;=== Biquad 4 ===
      dc   -0.35941076278687     ; -a(4,3)/2
      dc   0.00809240341187      ; -a(4,2)/2
      dc   0.31248295307159      ;  b(4,3)/2
      dc   0.22635257244110      ;  b(4,2)/2
      dc   0.31248295307159      ;  b(4,1)/2
                        

       org  X:StateArrayAddress  
state  ds   2*biquad


       org   p:$0
       jmp   start

       org   p:ProgramAddress

;*************************************************************
; Initialization and set up SSI
;*************************************************************

start

       ori   #$8,mr             ; set accumulator to scale up 
       aiset                    ; set-up the SSI port


;********************************************************
; Read ADC
;********************************************************
; The following code polls the RDF flag in the SSI-SR and
; waits for RDF=1 and then reads the RX register to
; retrieve the data from the A/D converter
;********************************************************

wait2

;*************************************************************
; receive data from ADC
;*************************************************************

wait1  jclr   #7,x:ssi_sr,wait1  ; wait for the ADC data
       movep  x:ssi_rx,x0        ; put ADC value into X0

      ;****************
      ;   IIR Filter
      ;****************

      move  #state,r0           ; r0 points to state
      move  #coeff,r4           ; r4 points to coefficients
      move  #igain,y1
      mpy   y1,x0,a  x:(r0)+,x0  y:(r4)+,y0 
                                ; put current state in Accumulator
                                ; load a(1,3) into y0
                                ; load w[n-2] into x0  
                                ; r0 points to w1[n-1]

      do    #biquad,mloop
      mac   x0,y0,a  x:(r0)-,x1  y:(r4)+,y0
                                ; y0 now contains a(1,2)
                                ; x1 now contains w[n-1]
                                ; r0 points to w[n-2]

      macr  x1,y0,a  x1,x:(r0)+  y:(r4)+,y0
                                ; w[n-1] is placed in w[n-2], 
                                ; but x0 still holds w[n-2]
                                ; r0 points to w[n-1]

      mpy   y0,x0,a  a,x:(r0)+  a,y1
                                ; a=b(1,3)*w[n-2]
                                ; store w[n] in w[n-1] for next stage
                                ; y1= w[n]

      move  y:(r4)+,y0      
                                ; y0=b(1,2)

      mac   x1,y0,a  y:(r4)+,y0           
                                ; a=b(1,3)w[n-2]+b(1,2)w[n-1],   
                                ; y0 now contains b(1,1)

      macr  y1,y0,a  y:(r4)+,y0  x:(r0)+,x0
                                ; a=b(1,1)w[n]+b(1,2)w[n-1]+b(1,3)w[n-2]
                                ; a contains input to next biquad
                                ; y0 contains a(2,3) of next biquad
                                ; x0 contains w[n-2] of next biquad
                                ; r0 points to w[n-1] of next biquad

mloop
      
;*******************************************************
; Write output data to the DAC
;*******************************************************

      movep  a,x:ssi_tx          ; output the result to the DAC

      jmp    wait2

      end

