;***********************************************************************
;
; IIR Filter Macro Code Demonstration Code
; Lattice Form Implementation
;
;***********************************************************************

      INCLUDE  'aiset.asm'           ; SSI port intialization macro
      INCLUDE  'iirlat.asm'          ; FIR Filtering macro

ssi_rx             equ   $ffef       ; SSI port receive register
ssi_tx             equ   $ffef       ; SSI port transmit register
ssi_sr             equ   $ffee       ; SSI port status register
ProgramAddress     equ   $100

;************************************************************************
;  Include the coefficient and memory initialization macro file
;  generated by DfP
;************************************************************************

      INCLUDE  'il_coef.asm'

;************************************************************************
;  Start the program
;************************************************************************

       org   p:$0
       jmp   start

       org   p:ProgramAddress

;*************************************************************
; Initialization and set up SSI
;*************************************************************

start

       aiset                    ; set-up the SSI port

wait2 

;*************************************************************
; receive data from ADC
;*************************************************************

wait1  jclr   #7,x:ssi_sr,wait1  ; wait for the ADC data
       movep  x:ssi_rx,x0        ; put ADC value into X0

       ;*************************
       ;   IIR Filtering Macro
       ;*************************

       iirlat order,r0str,coeff

;*******************************************************
; Write output data to the DAC
;*******************************************************

       movep  x0,x:ssi_tx        ; output the result to the DAC

       jmp    wait2

       end

