;**************************************************
;                                                  
; Created by     : Digital Filter Package (DFP)        
;                  Version  1.0  
;                                                  
; Created on     : 25-Feb-1997, 10:50  
;                                                  
;--------------------------------------------------
;                                                  
; Filter Type    : Low Pass  
;                                                  
;     Sampling Frequency =  48000 
;     Passband Edge =  12000 
;     Passband Attenuation (dB) =  4 
;     Stopband Edge =  15000 
;     Stopband Attenuation (dB) =  50 
;                                                  
; Design Method  : IIR/ChebyII  
; Implementation : Lattice  
; Coefficients   : [24,0,t]  
;                                                  
;**************************************************

  INCLUDE 'aiset.asm'

;***********************************************************************
;
; IIR Filter Code
; Generalized Lattice FIR/IIR Form Implementation
;
; For further information about this implementation for the Motorola
; DSP56k family of fixed point DSPs please see the help file:
;  
;     iir_lat.hlp
;
; $Revision: 1.2 $   $Date: 1997/02/25 15:24:19 $    $Author: mzeytin $ 
;
;***********************************************************************

ssi_rx             equ   $ffef       ; SSI port receive register
ssi_tx             equ   $ffef       ; SSI port transmit register
ssi_sr             equ   $ffee       ; SSI port status register


CoeffArrayAddress  equ  $0
StateArrayAddress  equ  $0
ProgramAddress     equ  $100
order              equ  7

       org  Y:CoeffArrayAddress  
coeff  dc   0.00364589691162      ; k(7)
       dc   0.03246390819550      ; k(6)
       dc   0.09880197048187      ; k(5)
       dc   0.32906603813171      ; k(4)
       dc   0.25454807281494      ; k(3)
       dc   0.84749221801758      ; k(2)
       dc   0.07703745365143      ; k(1)
       dc   0.06160843372345      ; c(8)
       dc   0.24529492855072      ; c(7)
       dc   0.43735098838806      ; c(6)
       dc   0.38390350341797      ; c(5)
       dc   0.07403051853180      ; c(4)
       dc   -0.16951596736908     ; c(3)
       dc   -0.10265684127808     ; c(2)
       dc   0.01660740375519      ; c(1)

       org  X:StateArrayAddress  
state  dsm  order+1


       org   p:$0
       jmp   start

       org   p:ProgramAddress

;*************************************************************
; Initialization and set up SSI
;*************************************************************

start

       aiset                    ; set-up the SSI port

;*************************************************************
;  Set up the registers
;*************************************************************

       move   #state,r0         ; point to filter state
       move   #order,m0         ; set modulo for R0
       move   #coeff,r4         ; point to filter coefficients
       move   #order*2,m4       ; set modulo for R4

       clr    b                 

wait2 

;*************************************************************
; receive data from ADC
;*************************************************************

wait1  jclr   #7,y:ssi_sr,wait1  ; wait for the ADC data
       movep  x:ssi_rx,a         ; put ADC value into x0

       ;*********************
       ;  IIR Lattice Filter
       ;*********************

       move           x:(r0)-,x0  y:(r4)+,y0     ;get first k, first s

       do    #order,_endlat                      ;calculate states
       macr  -y0,x0,a             b,x:(r0)+      ;a-k*s, save prev s
       move            a,y1       x:(r0)+,b      ;set a for mul, s again 
       macr  y1,y0,b  x:(r0)-,x0  y:(r4)+,y0     ;a*k+s, k, nxt s
_endlat

       move                       b,x:(r0)+      ;sv scnd to 1st st
       clr   a                    a,x:(r0)+      ;save first state
       move                       x:(r0)+,x0     ;get last state

       rep   #order
       mac   x0,y0,a  x:(r0)+,x0  y:(r4)+,y0     ;do fir taps
       macr  x0,y0,a              (r0)+          ;mac and round, adj pointer

;*******************************************************
; Write output data to the DAC
;*******************************************************

       movep  a,x:ssi_tx         ; output the result to the DAC

       jmp    wait2

       end

