;**************************************************
;                                                  
; Created by     : Digital Filter Package (DFP)        
;                  Version  1.0  
;                                                  
; Created on     : 25-Feb-1997, 10:49  
;                                                  
;--------------------------------------------------
;                                                  
; Filter Type    : Low Pass  
;                                                  
;     Sampling Frequency =  48000 
;     Passband Edge =  12000 
;     Passband Attenuation (dB) =  4 
;     Stopband Edge =  15000 
;     Stopband Attenuation (dB) =  50 
;                                                  
; Design Method  : IIR/ChebyII  
; Implementation : Polynomial  
; Coefficients   : [24,1,t]  
;                                                  
;**************************************************

  INCLUDE 'aiset.asm'

;***********************************************************************
;
; IIR Filter Code
; Direct Canonic Form Implementation with Scaling    
;
; For further information about this implementation for the Motorola
; DSP56k family of fixed point DSPs please see the help file:
;
;     iir_dir.hlp
;
; $Revision: 1.2 $   $Date: 1997/02/25 15:24:19 $    $Author: mzeytin $ 
;
;**********************************************************************

ssi_rx             equ   $ffef       ; SSI port receive register
ssi_tx             equ   $ffef       ; SSI port transmit register
ssi_sr             equ   $ffee       ; SSI port status register


igain              equ  0.5 
CoeffArrayAddress  equ  $0
StateArrayAddress  equ  $0
ProgramAddress     equ  $100
nstate             equ  8

       org  Y:CoeffArrayAddress  
coeff  dc   -0.23882746696472     ; -a(2)/2
       dc   -0.61191546916962     ; -a(3)/2
       dc   -0.25288736820221     ; -a(4)/2
       dc   -0.20694053173065     ; -a(5)/2
       dc   -0.05933046340942     ; -a(6)/2
       dc   -0.01710247993469     ; -a(7)/2
       dc   -0.00182294845581     ; -a(8)/2
       dc   0.03080427646637      ;  b(1)/2
       dc   0.13736128807068      ;  b(2)/2
       dc   0.31494331359863      ;  b(3)/2
       dc   0.46130454540253      ;  b(4)/2
       dc   0.46130454540253      ;  b(5)/2
       dc   0.31494331359863      ;  b(6)/2
       dc   0.13736128807068      ;  b(7)/2
       dc   0.03080427646637      ;  b(8)/2

       org  X:StateArrayAddress  
state  ds   nstate

       org   p:$0
       jmp   start

       org   p:ProgramAddress

;********************************************************
; Initialization and set up SSI
;********************************************************

start

       ori   #$8,mr          ; set accumulator to scale up 
       aiset                 ; set-up the SSI port

       move  #state,r0       ; point to filter states
       move  #nstate-1,m0    ; mod (nstate)
       move  #coeff,r4       ; point to filter coefficients
       move  #2*nstate-2,m4  ; mod (2*nstate-1)

;********************************************************
; Read ADC
;********************************************************
; The following code polls the RDF flag in the SSI-SR and
; waits for RDF=1 and then reads the RX register to
; retrieve the data from the A/D converter
;********************************************************

wait2 

;********************************************************
; receive data from ADC
;********************************************************

wait1  jclr   #7,x:ssi_sr,wait1               ; wait for the ADC data
       movep  x:ssi_rx,x0                     ; put ADC value into X0

      ;****************
      ;   Filter
      ;****************

      move  #igain,y1                         ; Scale factor used for x[n]

      mpy   y1,x0,a  x:(r0)+,x0  y:(r4)+,y0   ; A =x[n]/2, Y0=a(2), R4->a(3)
                                              ; X0=w[n-1], R0->w[n-2]
      ;**************
      ;  IIR part
      ;**************
      rep   #nstate-2                         
      mac   x0,y0,a  x:(r0)+,x0  y:(r4)+,y0
      macr  x0,y0,a              y:(r4)+,y0   ; A =w[n], R0->w[n-N]
                                              ; Y0=b(1), R4->b(2) 

      move           a,x:(r0)+                ; R0 -> w[n-1]
      move           a,x0                     ; X0 = w[n]
      mpy   x0,y0,a  x:(r0)+,x0  y:(r4)+,y0   ; A=b(1)w[n],X0=w[n-1],R0->w[n-2]
                                              ;            Y0=b(2),  R4->b(3)
      ;**************
      ;  FIR part
      ;**************
      rep   #nstate-2
      mac   x0,y0,a  x:(r0)+,x0  y:(r4)+,y0   
      macr  x0,y0,a                           ; A=y[n]

;*******************************************************
; Write output data to the DAC
;*******************************************************

      movep  a,x:ssi_tx                       ; output y[n] to the DAC

      jmp    wait2

      end

