;**************************************************
;                                                  
; Created by     : Digital Filter Package (DFP)        
;                  Version  1.0  
;                                                  
; Created on     : 25-Feb-1997, 10:48  
;                                                  
;--------------------------------------------------
;                                                  
; Filter Type    : Low Pass  
;                                                  
;     Sampling Frequency =  48000 
;     Passband Edge =  12000 
;     Passband Attenuation (dB) =  4 
;     Stopband Edge =  15000 
;     Stopband Attenuation (dB) =  50 
;                                                  
; Design Method  : FIR/Remez  
; Implementation : Lattice  
; Coefficients   : [24,0,t]  
;                                                  
;**************************************************

  INCLUDE 'aiset.asm'

;***********************************************************************
;
; FIR Filter Code
; Lattice Form Implementation
;
; For further information about this implementation for the Motorola
; DSP56k family of fixed point DSPs please see the help file:
;
;     fir_lat.hlp
;
; $Revision: 1.2 $   $Date: 1997/02/25 15:24:19 $    $Author: mzeytin $ 
;
;***********************************************************************

ssi_rx             equ   $ffef       ; SSI port receive register
ssi_tx             equ   $ffef       ; SSI port transmit register
ssi_sr             equ   $ffee       ; SSI port status register


CoeffArrayAddress  equ  $0
StateArrayAddress  equ  $0
ProgramAddress     equ  $100
ncoef              equ  20
GainF              equ  -0.48755568265915
GainL              equ  0.50000000000000

       org  Y:CoeffArrayAddress  
coeff  dc   -0.30447518825531     ; k(1)
       dc   0.22647535800934      ; k(2)
       dc   0.02668440341949      ; k(3)
       dc   -0.06384873390198     ; k(4)
       dc   0.08112275600433      ; k(5)
       dc   -0.01339805126190     ; k(6)
       dc   -0.19463360309601     ; k(7)
       dc   0.02991402149200      ; k(8)
       dc   0.44673597812653      ; k(9)
       dc   0.55509269237518      ; k(10)
       dc   0.33495366573334      ; k(11)
       dc   -0.02640461921692     ; k(12)
       dc   -0.10623288154602     ; k(13)
       dc   0.03114926815033      ; k(14)
       dc   0.05540311336517      ; k(15)
       dc   -0.03240346908569     ; k(16)
       dc   -0.03494191169739     ; k(17)
       dc   0.03976726531982      ; k(18)
       dc   0.06147050857544      ; k(19)
       dc   0.02488863468170      ; k(20)

       org  X:StateArrayAddress  
state  dsm  ncoef+1

       org   p:$0
       jmp   start

       org   p:ProgramAddress

;*************************************************************
; Initialization and set up SSI
;*************************************************************

start

       aiset                    ; set-up the SSI port

;*************************************************************
;  Set up the registers
;*************************************************************

       move   #state,r0         ; point to filter state
       move   #ncoef,m0         ; set modulo for R0
       move   #coeff,r4         ; point to filter coefficients
       move   #ncoef,m4         ; set modulo for R4

wait2 

;*************************************************************
; receive data from ADC
;*************************************************************

wait1  jclr   #7,x:ssi_sr,wait1  ; wait for the ADC data
       movep  x:ssi_rx,x0        ; put ADC value into X0

       ;*********************
       ;  FIR Lattice Filter
       ;*********************

       move             x0,b
       move             b,x:(r0)+    y:(r4)+,y0  ;save B as 1st st., mv fst k

       do     #ncoef,_endlat

       move             x:(r0),a     b,y1        ;get state, set t for mul by k
       macr   y1,y0,a   a,x1                     ;t*k+s, copy s
       macr   x1,y0,b   a,x:(r0)+    y:(r4)+,y0  ;s*k+t, sv st., nxt k

_endlat

       move   #GainF,y0
       mpy    x0,y0,a   b,x1      ; a=x[n]*GainF  b=Lattice o/p
       move   #GainL,y1
       mac    x1,y1,a             ; a=(GainF/2)*x[n] + (GainL/2)*Lattice o/p
       asl    a         (r0)-     ; a=2*a=y[n] and adjust pointer
       move             a,x0      ; move y[n] to x0 to be sent to the DAC   

;*******************************************************
; Write output data to the DAC
;*******************************************************

       movep  x0,x:ssi_tx         ; output the result to the DAC

       jmp    wait2

       end

