;**************************************************
;                                                  
; Created by     : Digital Filter Package (DFP)        
;                  Version  1.0  
;                                                  
; Created on     : 25-Feb-1997, 10:47  
;                                                  
;--------------------------------------------------
;                                                  
; Filter Type    : Low Pass  
;                                                  
;     Sampling Frequency =  48000 
;     Passband Edge =  12000 
;     Passband Attenuation (dB) =  4 
;     Stopband Edge =  15000 
;     Stopband Attenuation (dB) =  50 
;                                                  
; Design Method  : FIR/Remez  
; Implementation : Polynomial  
; Coefficients   : [24,0,t]  
;                                                  
;**************************************************

  INCLUDE 'aiset.asm'

;***********************************************************************
;
; FIR Filter Code
; Canonic Direct Form Implementation
;
; For further information about this implementation for the Motorola
; DSP56k family of fixed point DSPs please see the help file:
;  
;     fir_dir.hlp
;
; $Revision: 1.2 $   $Date: 1997/02/25 15:24:19 $    $Author: mzeytin $ 
; 
;***********************************************************************

ssi_rx             equ   $ffef       ; SSI port receive register
ssi_tx             equ   $ffef       ; SSI port transmit register
ssi_sr             equ   $ffee       ; SSI port status register


CoeffArrayAddress  equ  $0
StateArrayAddress  equ  $0
ProgramAddress     equ  $100
ntaps              equ  21


       org  Y:CoeffArrayAddress  
coeff  dc   0.02488863468170      ; b(1)
       dc   0.06300044059753      ; b(2)
       dc   0.04447567462921      ; b(3)
       dc   -0.03048920631409     ; b(4)
       dc   -0.03517484664917     ; b(5)
       dc   0.04943943023682      ; b(6)
       dc   0.03600251674652      ; b(7)
       dc   -0.09651637077332     ; b(8)
       dc   -0.03789234161377     ; b(9)
       dc   0.31497073173523      ; b(10)
       dc   0.53863859176636      ; b(11)
       dc   0.31497073173523      ; b(12)
       dc   -0.03789234161377     ; b(13)
       dc   -0.09651637077332     ; b(14)
       dc   0.03600251674652      ; b(15)
       dc   0.04943943023682      ; b(16)
       dc   -0.03517484664917     ; b(17)
       dc   -0.03048920631409     ; b(18)
       dc   0.04447567462921      ; b(19)
       dc   0.06300044059753      ; b(20)
       dc   0.02488863468170      ; b(21)

       org  X:StateArrayAddress  
state  dsm  ntaps

       org   p:$0
       jmp   start

       org   p:ProgramAddress

;*************************************************************
; Initialization and set up SSI
;*************************************************************

start

       aiset                    ; set-up the SSI port
 
;*************************************************************
;  Set up the registers
;*************************************************************

       move   #state,r0         ; point to filter state
       move   #ntaps-1,m0       ; set modulo for R0
       move   #coeff,r4         ; point to filter coefficients
       move   #ntaps-1,m4       ; set modulo for R4


wait2 

;*************************************************************
; receive data from ADC
;*************************************************************

wait1  jclr   #7,x:ssi_sr,wait1  ; wait for the ADC data
       movep  x:ssi_rx,x0        ; put ADC value into X0

       ;**************
       ;  FIR Filter
       ;**************

       clr    a          y:(r4)+,y0  x0,x:(r0)+
                                 ; clear the accumulator
                                 ; store state on top
       rep    #ntaps-1
       mac    x0,y0,a   x:(r0)+,x0   y:(r4)+,y0
       macr   x0,y0,a   (r0)-    

;*******************************************************
; Write output data to the DAC
;*******************************************************

       movep  a,x:ssi_tx          ; output the result to the DAC

       jmp    wait2
       
       end

