;****************************************************************************
;
;    IIR Filtering Macro
;    Cascade of Biquad Sections with Scaling
; 
;    $Revision: 1.1 $    $Date: 1997/02/25 15:27:23 $   $Author: mzeytin $
;
;****************************************************************************
;
;    Macro Call
;    ----------
;      iirsos   biquad,coeff,state
;
;    Parameters
;    ----------
;      biquad   :  number of biquad sections 
;      coeff    :  starting of the coefficient array in the Y-memory
;      state    :  starting address of the filter states array in X-memory
;
;    Memory usage
;    ------------
;      X-memory :  2*biquad elements (starting at #state)
;      Y-memory :  5*biquad for filter coefficients (starting at #coeff)
;
;    Data input and output
;    ---------------------
;      i/p x[n] :  is assumed to be in X0
;      o/p y[n] :  will be in X0 at the completion of the macro
;
;    Alters the following registers
;    ------------------------------
;      Program control registers :  MR
;      Address registers         :  R0 R4
;      Data ALU registers        :  X0 X1 Y0 Y1
;                                   A0 A1 A2
;
;****************************************************************************

iirsos macro  biquad,coeff,state
iirsos ident  1,1

       ori   #$08,mr             ; set scaling mode
       move  #state,r0           ; R0 points to state
       move  #coeff,r4           ; R4 points to coefficients
       move  #0.5,y1             ; scale down x[n] by 2 compatible with
                                 ; the processor scaling mode

       mpy   y1,x0,a  x:(r0)+,x0  y:(r4)+,y0
                                 ; put current state in Accumulator
                                 ; load a(3) into Y0
                                 ; load w[n-2] into X0
                                 ; R0 points to w1[n-1]

       do    #biquad,_mloop
       mac   x0,y0,a  x:(r0)-,x1  y:(r4)+,y0
                                 ; Y0 now contains a(2)
                                 ; X1 now contains w[n-1]
                                 ; R0 points to w[n-2]

       macr  x1,y0,a  x1,x:(r0)+  y:(r4)+,y0
                                 ; w[n-1] is placed in w[n-2],
                                 ; but X0 still holds w[n-2]
                                 ; R0 points to w[n-1]

       mpy   y0,x0,a  a,x:(r0)+  a,y1
                                 ; A=b(3)w[n-2]
                                 ; store w[n] in w[n-1] for next stage
                                 ; Y1=w[n]

       move  y:(r4)+,y0
                                 ; Y0=b(2)

       mac   x1,y0,a  y:(r4)+,y0
                                 ; A=b(3)w[n-2]+b(2)w[n-1],
                                 ; Y0 now contains b(1)

       macr  y1,y0,a  y:(r4)+,y0  x:(r0)+,x0
                                 ; A=b(1)w[n]+b(2)w[n-1]+b(3)w[n-2]
                                 ; A  contains input to next biquad
                                 ; Y0 contains a(3) of next biquad
                                 ; X0 contains w[n-2] of next biquad
                                 ; R0 points to w[n-1] of next biquad

_mloop

       move  a,x0                ; move y[n] to X0 (which scales it up)

       andi  #$f7,mr             ; remove scaling mode

       endm


