;****************************************************************************
;
;    IIR Filtering Macro
;    Lattice Implementation
;
;    $Revision: 1.1 $    $Date: 1997/02/25 15:27:23 $   $Author: mzeytin $
;
;****************************************************************************
;
;    Macro Call
;    ----------
;      iirlat   order,r0str,coeff
;
;    Parameters
;    ----------
;      order   :  filter order (equals to number of k-coefficients)
;      r0str   :  address of temporary storage location in X-memory for the
;                 oldest filter state in the state array.  State array is
;                 in the X-memory.
;      coeff   :  start of the coefficient array in the Y-memory
;
;    Memory usage
;    ------------
;      X-memory :  order elements (order+1 modulo storage)
;               :  one memory for storing R0, pointer to state address
;      Y-memory :  (2*order+1) elements
;
;    Data input and output
;    ---------------------
;      i/p x[n] :  is assumed to be in X0
;      o/p y[n] :  will be in X0 at the completion of the macro
;
;    Alters the following registers
;    ------------------------------
;      Address registers         :  R0 R4 M0
;      Data ALU registers        :  X0 Y0 Y1 
;                                   A0 A1 A2
;                                   B0 B1 B2
;
;****************************************************************************

iirlat  macro  order,r0str,coeff
iirlat  ident  1,1


       move   x:r0str,y0
       move   y0,r0             ; restore R0 to point to oldest filter state
       move   #order,m0         ; set modulo for R0
       move   #coeff,r4         ; R4 points to coefficients

       clr    b         x0,a

       ;*********************
       ;  IIR Lattice Filter
       ;*********************

       move           x:(r0)-,x0  y:(r4)+,y0     ;get first k, first s

       do    #order,_endlat                      ;calculate states
       macr  -y0,x0,a             b,x:(r0)+      ;a-k*s, save prev s
       move           a,y1        x:(r0)+,b      ;set a for mul, s again
       macr  y1,y0,b  x:(r0)-,x0  y:(r4)+,y0     ;a*k+s, k, nxt s
_endlat

       move                       b,x:(r0)+      ;sv scnd to 1st st
       clr   a                    a,x:(r0)+      ;save first state
       move                       x:(r0)+,x0     ;get last state

       rep   #order
       mac   x0,y0,a  x:(r0)+,x0  y:(r4)+,y0     ;do fir taps
       macr  x0,y0,a              (r0)+          ;mac and round, adj pointer

       move           a,x0      ; move y[n] to x0 to be sent to the DAC
       move           r0,y0     ; save the most current value of R0
       move           y0,x:r0str

       endm
