;****************************************************************************
;
;    IIR Filtering Macro
;    Canonic Direct Form Implementation with Scaling
;
;    $Revision: 1.1 $    $Date: 1997/02/25 15:27:23 $   $Author: mzeytin $
;
;****************************************************************************
;
;    Macro Call
;    ----------
;      iirdir   nstate,r0str,coeff
;
;    Parameters
;    ----------
;      nstate   :  number of filter states (=N) for an (N-1) order filter
;      r0str    :  address of temporary storage location in X-memory for the
;                  "most recent" (for example w[n-1] as x[n] arrives) filter 
;                  state in the state array.  State array is in the X-memory
;      coeff    :  starting address of the coefficient array in the Y-memory
;
;    Memory usage
;    ------------
;      X-memory :  nstate elements to store filter states 
;               :  one element for storing R0, pointer to the state array
;      Y-memory :  2*nstate-1 elements for coefficients (starting at #coeff)
;
;    Data input and output
;    ---------------------
;      i/p x[n] :  is assumed to be in X0
;      o/p y[n] :  will be in X0 at the completion of the macro
;
;    Alters the following registers
;    ------------------------------
;      Program control registers :  MR
;      Address registers         :  R0 R4 M0
;      Data ALU registers        :  X0 X1 Y0 Y1
;                                   A0 A1 A2
;
;****************************************************************************

iirdir  macro  nstate,r0str,coeff
iirdir  ident  1,1

       ori   #$08,mr                           ; set scaling mode

       move  x:r0str,y0                        ; restore R0 -> w[n-1]
       move  y0,r0               
       move  #nstate-1,m0                      ; set modulo (nstate) for R0
       move  #coeff,r4                         ; R4 -> a(2) 
       move  #0.5,y1                           ; scale factor for x[n] 

       mpy   y1,x0,a  x:(r0)+,x0  y:(r4)+,y0   ; A =x[n]/2, Y0=a(2), R4->a(3)
                                               ; X0=w[n-1], R0->w[n-2]
       ;**************
       ;  IIR part
       ;**************
       rep   #nstate-2                         
       mac   x0,y0,a  x:(r0)+,x0  y:(r4)+,y0
       macr  x0,y0,a              y:(r4)+,y0   ; A =w[n], Y0=b(1), R0->w[n-N]
                                               ; R4->b(2)

       move           a,x:(r0)+                ; R0 -> w[n-1]
       move           a,x0                     ; X0 = w[n]
       mpy   x0,y0,a  x:(r0)+,x0  y:(r4)+,y0   ; A=b(1)w[n],X0=w[n-1],R0->w[n-2]
                                               ;            Y0=b(2),  R4->b(3)
       ;**************
       ;  FIR part
       ;**************
       rep   #nstate-2
       mac   x0,y0,a  x:(r0)+,x0  y:(r4)+,y0   
       macr  x0,y0,a                           ; A=y[n]

       move  a,x0                              ; move y[n] to X0 
                                               ; (which scales it up)
       move  r0,y0                             ; save the current value of R0
       move  y0,x:r0str

       andi  #$f7,mr                           ; remove scaling mode

       endm


