;****************************************************************************
;
;    FIR Filtering Macro
;    Modified Lattice Implementation
;
;    $Revision: 1.1 $    $Date: 1997/02/25 15:27:23 $   $Author: mzeytin $
;
;****************************************************************************
;
;    Macro Call
;    ----------
;      firlat   ncoef,r0str,coeff,GainF,GainL
;
;    Parameters
;    ----------
;      ncoef   :  number of number of filter coefficients
;      r0str   :  address of temporary storage location in X-memory for the
;                 oldest filter state in the state array.  State array is
;                 in the X-memory.
;      coeff   :  start of the coefficient array in the Y-memory
;      GainF   :  forward gain (scaled down by 2)
;      GainL   :  lattice gain (scaled down by 2)
;
;    Memory usage
;    ------------
;      X-memory :  ncoef elements (ncoef+1 modulo storage)
;               :  one memory for storing R0, pointer to state address
;      Y-memory :  ncoef elements
;
;    Data input and output
;    ---------------------
;      i/p x[n] :  is assumed to be in X0
;      o/p y[n] :  will be in X0 at the completion of the macro
;
;    Alters the following registers
;    ------------------------------
;      Address registers         :  R0 R4 M0
;      Data ALU registers        :  X0 X1 Y0 Y1
;                                   A0 A1 A2
;                                   B0 B1 B2
;
;****************************************************************************

firlat  macro  ncoeff,r0str,coeff,GainF,GainL
firlat  ident  1,1


       move   x:r0str,y0
       move   y0,r0             ; restore R0 to point to oldest filter state
       move   #ncoef,m0         ; set modulo for R0
       move   #coeff,r4         ; R4 points to coefficients

       move             x0,b
       move             b,x:(r0)+    y:(r4)+,y0  ;save B as 1st st., mv fst k

       do     #ncoef,_endlat

       move             x:(r0),a     b,y1        ;get state, set t for mul by k
       macr   y1,y0,a   a,x1                     ;t*k+s, copy s
       macr   x1,y0,b   a,x:(r0)+    y:(r4)+,y0  ;s*k+t, sv st., nxt k

_endlat

       move   #GainF,y0
       mpy    x0,y0,a   b,x1      ; a=x[n]*GainF  b=Lattice o/p
       move   #GainL,y1
       mac    x1,y1,a             ; a=(GainF/2)*x[n] + (GainL/2)*Lattice o/p
       asl    a         (r0)-     ; a=2*a=y[n] and adjust pointer

       move             a,x0      ; move y[n] to x0 to be sent to the DAC
       move   r0,y0               ; save the most current value of R0
       move   y0,x:r0str

       endm
