;****************************************************************************
;
;    FIR Filtering Macro
;    Canonic Direct Form Implementation 
;
;    $Revision: 1.1 $    $Date: 1997/02/25 15:27:23 $   $Author: mzeytin $
;
;****************************************************************************
;
;    Macro Call
;    ----------
;      firdir   ntaps,r0str,coeff
;
;    Parameters
;    ----------
;      ntaps   :  number of number of filter coefficients
;      r0str   :  address of temporary storage location in X-memory for the
;                 oldest filter state in the state array.  State array is 
;                 in the X-memory.
;      coeff   :  start of the coefficient array in the Y-memory
;
;    Memory usage
;    ------------
;      X-memory :  ntaps elements (ntaps-modulo storage)
;               :  one memory for storing R0, pointer to state address
;      Y-memory :  ntaps elements
;
;    Data input and output
;    ---------------------
;      i/p x[n] :  is assumed to be in X0
;      o/p y[n] :  will be in X0 at the completion of the macro
;
;    Alters the following registers
;    ------------------------------
;      Address registers         :  R0 R4 M0
;      Data ALU registers        :  X0 Y0
;                                   A0 A1 A2
;
;****************************************************************************

firdir  macro  ntaps,r0str,coeff
firdir  ident  1,1

       move   x:r0str,y0
       move   y0,r0             ; restore R0 to point to oldest filter state
       move   #ntaps-1,m0       ; set modulo for R0
       move   #coeff,r4         ; R4 points to coefficients
       nop

       clr    a   y:(r4)+,y0  x0,x:(r0)+       ; clear the accumulator
                                               ; store state on top
       rep    #ntaps-1
       mac    x0,y0,a   x:(r0)+,x0   y:(r4)+,y0
       macr   x0,y0,a   (r0)-

       move   a,x0              ; move y[n] to X0 
       move   r0,y0             ; save the most current value of R0
       move   y0,x:r0str

       endm


