%  README file for the Digital Filter Package (DFP)
%
%  Version: 1.0.1    Release Date: 11.March.1997
%
%  1. INTRODUCTION
%  ===============
%  This is V1.0.1 release of the Digital Filter Package.  DFP is a user
%  friendly GUI front-end to the digital filter design components included
%  with the MATLAB Signal Processing Toolbox.   DFP also extends the basic
%  digital filter design functionality of MATLAB in two important ways.
%  The filter coefficients can be quantized.  This feature is of particular
%  importance if the filter will eventually be implemented on a fixed point
%  DSP.  DFP also generates assembler code for the designed digital filter.
%  In V1.0, this option is available only for the Motorola DSP56k family of 
%  fixed point processors.
%  
%  2. COMPATIBILITY
%  ================
%  DFP requires MATLAB version 4.2 or higher.  Signal Processing Toolbox is
%  required.  It has been tested on Sun computers running Solaris, SunOS, 
%  Linux and Windows on 486 and Pentium class computers.  DFP also requires
%  a number of M-files from the Mathworks UITOOLS distribution.  You may
%  already have UITOOLS installed on your systems.  If not, they are
%  available from the Mathworks FTP site.
%
%  Please note that as of this release date (25.February.1997) DFP has
%  not been tested with MATLAB version 5.0.
% 
%  3. FEATURES
%  ===========
%  The following list provides the main features of DFP.  This list is by
%  no means intended to be comprehensive.  I recommend everyone to spend
%  some time using the package in order to have a better understanding of
%  DFP's capabilities.
%
%     o Filter Types: 
%               lowpass, 
%               highpass, 
%               bandpass, 
%               bandstop,
%               differentiator, 
%               Hilbert transformer.
%
%     o Filter Design Methods: 
%          FIR: Remez (Parks-McClellan) equiripple FIR design;
%               windowed linear phase FIR digital filter design;
%               least squares linear phase FIR filter design           
%          IIR: Butterworth;
%               Chebychev I;                   
%               Chebychev II;                   
%               Elliptic.
%          Interactive Pole-Zero Placement (*)
%
%     o Filter order estimation based on filter specifications.
%
%     o Filter Implementation: 
%               polynomial, 
%               lattice,
%               second-order-system implementation (for IIR).
%
%     o Filter Coefficient Format: 
%               floating point, 
%               fixed point.  The user can specify:
%                 i.   total number of bits (any positive integer value),
%                 ii.  number of integer bits, 
%                 iii. two's complement or "unsigned integer" formats.
%
%     o Output Options: 
%               transfer filter coefficients to the MATLAB workspace,
%               Motorola DSP56K code generation
%
%     o Display Options:
%               Magnitude Response (linear/dB)
%               Filter target display (linear/dB if applicable)
%               Phase Response (degrees/radians, wrap/unwrap)
%               Group Delay (user specified points)
%               Unit Sample Response (user specified points)
%               Pole-Zero Plot
%               Filter Coefficients (in floating point, hexadecimal, octal,
%                 and binary formats) in scrollable text fields.
%
%     o Other Features:
%               Global and individual based customization.
%               GUI based customization of DFP parameters.
%               Automatic color assignment for monochrome and color monitors.
%               Error checking.
%               On-line, context sensitive help facility (*)
%
%  (*) These features are yet not available in this release.  
%  
%  4. REMARKS
%  ==========
%  There are a number of features that I plan to add to the basic package.
%  These changes mostly represent expansion of the Filter Types from the 
%  six listed above to include other useful ones; and to write a filter
%  design module based on interactive pole-zero placement.  This last feature 
%  may not be of much practical use, but it is an important teaching tool. 
%  
%
%  5. ACKNOWLEDGMENTS
%  ===================
%  In writing this package I have used code written by other Matlab users.
%  I have retained their copyright notices and/or names in these files.
%  However, I also added a brief notice to these files if I had modified 
%  any one of them.  In particular I would like to express my thanks to
%  the following Matlab users who have made their code available:
%    o Erik A. Johnson <johnsone@uxh.cso.uiuc.edu> ........ (arrow.m)
%    o Kevin G. Kohrt ..................................... (dateme.m)
%    o Hans Olsson from Lund .............................. (dec2bin.m)
%      (This file also serves as the basis for int2hex.m and int2oct.m)
%    o Uwe Petersen ....................................... (timedate.m)
%    o D.L. Hallman <hallman@helmholtz.ecn.purdue.edu> .... (uiprint.m)
%    o Motorola DSP bulletin board for most of the initial assembler code
%      templates.
%
% Use HELP on these files or TYPE them for more information.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
