% Digital Filter Package.
%
% Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%         Department of Electrical and Computer Engineering
%         Ryerson Polytechnic University
%         Toronto, Ontario, M5B 2K3 
%         CANADA
%
% Copyright (c) 1997 Mehmet Zeytinoglu
%
% $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%
%
% Graphical User Interface
%   dfp        - initialization function for the DIGITAL FILTER PACKAGE (DfP)
%   dfprc      - DFP properties user specific initialization script
%   dfprcdef   - DFP properties global default initialization script
%   d_global   - initializes the global variables and parameters that 
%                determine the look and feel of DFP.
%
% NAVIGATOR Related Functions
%   d_navgtr   - creates and initializes the "NAVIGATOR" window
%   d_navgcb   - callback for the checkbox and pop-up-menu uicontrols 
%                of the "NAVIGATOR" window
%   d_fileio   - callbacks corresponding to the OPEN, SAVE, and NEW menu 
%                items in the "NAVIGATOR" window.
%
% TYPE & SPECIFICATIONS Window Related Functions
%   d_tspint   - creates and initializes the "TYPE and SPECIFICATIONS" window
%   d_tspsup   - prepares the "TYPE and SPECIFICATIONS" window for different
%                filter types
%   d_tspchk   - checks the values entered into the editable fields of the
%                "TYPE and SPECIFICATIONS" window for consistency
%   d_tspcb    - callback for the APPLY pushbutton in the "TYPE and 
%                SPECIFICATIONS" window
%
% DESIGN METHOD Window Related Function
%   d_mtdint   - creates and initializes the "DESIGN METHOD" window
%   d_mtdsup   - prepares the radiobuttons in the "DESIGN METHOD" window
%   d_mtdcb    - callback function for the "DESIGN METHOD" window
%
% DISPLAY Window Related Functions
%   d_disply   - creates and initializes the "DISPLAY" window and its children
%   d_dplydr   - updates the magnitude, phase/group-delay/impulse response 
%                plots in the "DISPLAY" window
%   d_almncb   - controls the axis limits menu callback in the DISPLAY window
%   d_cfmtcb   - generates the string arrays to be displayed in the editable 
%                text windows of the DISPLAY window under user specified format
%   d_csldcb   - callback for the sliders in the coefficient DISPLAY window
%   d_datest   - callback for the Time-Stamp/Menu of any snapshot figure
%                generated by the Snapshot/Menu in the DISPLAY window.
%   d_format   - generate a string array in the specified format
%   d_grmncb   - callback function for the Grid/Menu in the "DISPLAY" window
%   d_numncb   - partial callback function for the OTHER-Menu in the 
%                "DISPLAY" window
%   d_resize   - callback of the "PoZe/Coff" checkbox in the "NAVIGATOR" window
%   d_scmncb   - callback for the SCALE-MENU in the "DISPLAY" window
%   d_setlbl   - changes the status labels in the "DISPLAY" window
%   d_spmncb   - callback for the SNAPSHOT-MENU in the "DISPLAY" window
%   d_tgdraw   - draws target into the Magnitude AXES of the "DISPLAY" window
%   d_tgmncb   - callback used by the TARGET-MENU in the "DISPLAY" window
%   d_tgtgen   - prepares target data from filter specifications
%
% IMPLEMENTATION Window Related Functions 
%   d_recoef   - creates and initializes the "IMPLEMENTATION" window
%   d_recocb   - callback for UICONTROL objects in the "IMPLEMENTATION" window
%   d_implmt   - generates the user specified filter realisation
%
% OUTPUT Window Related Functions
%   d_output   - creates and initializes the "OUTPUT" window
%   d_outpcb   - callback function for the "OUTPUT" window
%   d_transf   - transfer script that copies user specified variables to the
%                MATLAB base workspace
%   d_codgen   - Code generation routines
%
% PROPERTIES Window Related Functions
%   d_propts   - arbitrates among "d_proclr" and "d_probaw" to determine
%                which one will generate the "PROPERTIES" window 
%   d_probaw   - creates and initializes the "PROPERTIES" window for 
%                black & white monitors
%   d_proclr   - creates and initializes the "PROPERTIES" window for 
%                color monitors
%   d_prbwcb   - callback function for the "PROPERTIES" window (black & white)
%   d_prclcb   - callback function for the "PROPERTIES" window (color)
%   d_propsv   - saves the customizable parameters to the file DFPRC.M
%   d_rstdef   - restores user modifiable DFP properties to default values 
%                relative to the start of the "PROPERTIES" dialog box
%
% Other DfP Related Functions
%   d_axldlg   - creates and manages the axes limits dialog box
%   d_error    - database server for error and warning messages generated by DfP
%   d_logo     - creates the Help/About information window
%   d_namesv   - figure title/name database server
%   d_inpdlg   - creates and manages an input dialog box
%
% Utility Functions
%   arrow      - draw a line with an arrowhead
%   d_quant    - maps a floating point sequence into a quantized sequence
%   d_append   - appends one file to another
%   dateme     - applies current date to a figure
%   dec2bin    - converts integer to a binary string
%   difford    - estimates the order of optimal FIR differentiators
%   firlsa     - modified LS FIR filter design function
%   hilbord    - estimates the order of optimal FIR Hilbert Transformer
%   int2hex    - convert integer to a hexadecimal string
%   int2oct    - convert integer to an octal string
%   kaiseord   - estimates the order of a Kaiser windowed FIR filter
%   lat2poly   - compute polynomial coefficients from reflection coefficients
%   limiter    - applies lower and upper bounds on the input sequence
%   poly2lat   - compute reflection from polynomial coefficients
%   timedate   - returns a string containing current date and time
%   uiprint    - a GUI for printing a figure from Matlab
