
% Subor testuje vypocet FFT256 funkcie vypocitanej v prostredi VisualDSP


load x.dat		% vstupne vzorky nacitavane cez seriovy kanal SPORT0
load y_real.dat		% ralna cast vystupu FFT256
load y_imag.dat		% imaginarna cast vystupu FFT256
x = x(1:256) + i*x(257:512);	% komplexny vstup FFT256 je vytvoreny z x.dat
y = y_real + i*y_imag;	% komplexny vystup urceny v ADSP
yy = abs(y);		% absolutna hodnota spektra urceneho v ADSP
xx = abs(fft(x));	% absolutna hodnota spektra (referencny vypocet v Matlabe)


e = yy - xx;		% rozdiel medzi Matlabom a VisualDSP
plot(e);        	% priebeh chyby
title('Chyba vypoctu funkcie FFT256 v ADSP218x');
xlabel('Vzorka');
ylabel('Chyba');
grid;
