#define N 512

/* .h subor, ktory definuje vstupne body a makra */
#include <asm_sprt.h>
#include <def2181.h>

.extern _Buffer1;
.extern _Buffer0;
.extern _db_tgl;

.extern _Bit_Reversal_On;
.extern _DoFFT;

.section /pm program;

.global SPORT0_RX_Interrupt;
SPORT0_RX_Interrupt:

        /* Najskor povolime tienovu banku registrov, aby nedoslo k modifikacii registrov
           pouzivanych v C prostredi */
        ena SEC_REG;

        /* Testovanie ci interupt bol vyvolany mechanizmom autobufrovania (t.j. navratom
           registra i2 na zaciatok cirkulacnej pamate), alebo doslo k prijmu novej vzorky pri
           vypnutom autobufrovani? */

        ax0 = dm(_Bit_Reversal_On);
        ar = pass ax0;
        if EQ jump      Autobuffering_Interrupt;
Non_Autobuffering_Interrupt:

        /* Zakazanie bitovo-reverzneho adresovania (v DAG1), takze data mozu byt spravne ulozene */
        dis     BIT_REV;

        ax0     = rx0;
        ay1 = i2;
        dm(i2,m1) = ax0;
        ax1 = i2;

        /* Kontrola pretecenia i2 registra spat na zaciatok cirkulacnej pamate, ak ano,
           je potrebne generovat obsluhu spracovania autobufrovania */
        ar = ax1 - ay1;
        if LT jump Autobuffering_Interrupt;

        /* Pri vyvolani prerusenia su stavove registre ulozene do stavoveho zasobnika.  Pri navrate
           z prerusenia su tieto hodnoty automaticky obnovene a hoci sme povolili tienovu banku
           registrov a zakazli bitovo-reverzne adresovanie, nie je potrebne ich obnovovat, pretoze
           toto zabezpeci (automatickym obnovenim hodnot zo zasobnika) RTI instrukcia! */
        rti;


Autobuffering_Interrupt:
        ax0 = 1;
        dm(_DoFFT) = ax0;

        ax0 = dm(_db_tgl);
        ar = pass ax0;
        IF NE jump Buffer0_Use;

Buffer1_Use:
        i2 = _Buffer1;
        ar = NOT ar;
        dm(_db_tgl) = ar;
        rti;

Buffer0_Use:
        i2 = _Buffer0;
        ar = NOT ar;
        dm(_db_tgl) = ar;
        rti;


