/****************************************************************************

Copyright (c) 1999-2001 Analog Devices Inc. All rights reserved.

Priklad implementacie tabulky vektorov preruseni
****************************************************************************/

#ifndef __ADSP218X__
#  define  __ADSP218X__
#endif

#include <signal.h>

.extern __lib_int_table;
.extern __lib_int_determiner;
.extern _____system_start;

/* deklaracia extrernej referencie pre obsluhu prerusenia od prijimaca SPORT0  */
.extern SPORT0_RX_Interrupt;

.section/code   IVreset;
.global                 ___reset;

___reset:
                JUMP  _____system_start;
                RTI;
                RTI;
                RTI;

.section/code IVpwrdwn;
.global ___pwrdwn;
___pwrdwn:
                DM(I4+=M7)=AX1;                  // ulozenie do softveroveho zasobnika v DM
                AX1=SIGPWRDWN;
                JUMP __lib_int_determiner;
                RTI;                             // v originalnom kode 218x_int_tab.asm
                                                 // tu bola instrukcia NOP, do tohto bodu
                                                 // sa vsak kod pri spravnej funkcii nikdy
                                                 // nedostane, pretoze navrat (pomocou RTI)
                                                 // zabezpeci __lib_int_determiner;

.section/code IVirq2;
.global ___irq2;
___irq2:
                DM(I4+=M7)=AX1;                  // ulozenie do softveroveho zasobnika v DM
                AX1=SIGIRQ2;
                JUMP __lib_int_determiner;
                RTI;

.section/code IVirql1;
.global ___irql1;
___irql1:
                DM(I4+=M7)=AX1;                  // ulozenie do softveroveho zasobnika v DM
                AX1=SIGIRQL1;
                JUMP __lib_int_determiner;
                RTI;

.section/code IVirql0;
.global ___irql0;
___irql0:
                DM(I4+=M7)=AX1;                  // ulozenie do softveroveho zasobnika v DM
                AX1=SIGIRQL0;
                JUMP __lib_int_determiner;
                RTI;

.section/code IVsport0xmit;
.global ___sport0xmit;
___sport0xmit:
                DM(I4+=M7)=AX1;                  // ulozenie do softveroveho zasobnika v DM
                AX1=SIGSPORT0XMIT;
                JUMP __lib_int_determiner;
                RTI;



/* v tomto vektore nahradzujeme C obsluhu vlastnou funkciuou SPORT0_RX_Interrupt */

.section/code IVsport0recv;
.global ___sport0recv;
___sport0recv:
                JUMP SPORT0_RX_Interrupt;
                RTI;
                RTI;
                RTI;

.section/code IVirqe;
.global ___irqe;
___irqe:
                DM(I4+=M7)=AX1;                  // ulozenie do softveroveho zasobnika v DM
                AX1=SIGIRQE;
                JUMP __lib_int_determiner;
                RTI;

.section/code IVbdma;
.global ___bdma;
___bdma:
                DM(I4+=M7)=AX1;                  // ulozenie do softveroveho zasobnika v DM
                AX1=SIGBDMA;
                JUMP __lib_int_determiner;
                RTI;

.section/code IVirq1;
.global ___irq1;
___irq1:
                DM(I4+=M7)=AX1;                  // ulozenie do softveroveho zasobnika v DM
                AX1=SIGIRQ1;
                JUMP __lib_int_determiner;
                RTI;

.section/code IVirq0;
.global ___irq0;
___irq0:
                DM(I4+=M7)=AX1;                  // ulozenie do softveroveho zasobnika v DM
                AX1=SIGIRQ0;
                JUMP __lib_int_determiner;
                RTI;

#ifdef __ADSP2189__

.section/code IVtimer89;
.global ___tmri89;
___tmri89:
      CALL ___lib_tmri_ctrl;
      NOP;NOP;
      RTI;

#else

.section/code IVtimer;
.global ___tmri;
___tmri:
                DM(I4+=M7)=AX1;                  // ulozenie do softveroveho zasobnika v DM
                AX1=SIGTIMER;
                JUMP __lib_int_determiner;
                RTI;

#endif

// end of file
