% This m-file demonstrates high sensitivity of direct IIR realization (of 
% relatively complex IIR filter). The direct realization is instable also 
% in double-precission Matlab environment. 
% IIR filter realization in the form of casacde of biquad sections is 
% stable.

% M.Drutarovsky., KEMT FEI TU Kosice, 03-04-2006

% design of a complex IIR filter (A,B are polynomials of 20-th order)
[b,a,v,u,C]=iirdes('ell','p',[0.19 0.2 0.25 0.26]*pi,0.01,0.00001);

t=(1:10000);		% discrete time
fsig=0.22*pi;		% frequency from the passband of IIR
x=1.0*sin(2*pi*fsig*t/(2*pi));	% input signal with fsig frequency

% output of direct IIR filter realization
y=filter(b,a,x);	% output of direct IIR filter realization
figure(1)
plot(y);
title('Instability of direct IIR filter realization');


% output of (biquads) cascade realization
[nsec,dsec]=pairpz(v,u);
yc=cascade(C,nsec,dsec,x);
figure(2);
plot(yc);
title('Stable output of (biquad) cascade realization');

