// MD pridana podpora pre blokove spracovanie a IIR filtraciu

//--------------------------------------------------------------------------//
//                                                                                                                                                      //
//       Name:  Talkthrough for the ADSP-BF533 EZ-KIT Lite                                              //
//                                                                                                                                                      //
//--------------------------------------------------------------------------//
//                                                                                                                                                      //
//      (C) Copyright 2006 - Analog Devices, Inc.  All rights reserved.                 //
//                                                                                                                                                      //
//      Project Name:   BF533 C Talkthrough TDM                                                                 //
//                                                                                                                                                      //
//      Date Modified:  04/03/03                Rev 1.0                                                 //
//                                                                                                                                                      //
//      Software:               VisualDSP++4.5                                                                                  //
//                                                                                                                                                      //
//      Hardware:               ADSP-BF533 EZ-KIT Board                                                                 //
//                                                                                                                                                      //
//      Connections:    Disconnect RSCLK0 and TSCLK0 (Turn SW9 pin 6 OFF)           //
//                  Disconnect RFS0 and TFS0 (Turn SW9 pin 5 OFF)                   //
//                  Connect an input source (such as a radio) to the Audio      //
//                                      input jack and an output source (such as headphones) to //
//                                      the Audio output jack                                                                   //
//                                                                                                                                                      //
//      Purpose:                This program sets up the SPI port on the ADSP-BF533 to  //
//                                      configure the AD1836 codec.  The SPI port is disabled   //
//                                      after initialization.  The data to/from the codec are   //
//                                      transfered over SPORT0 in TDM mode                                              //
//                                                                                                                                                      //
//--------------------------------------------------------------------------//

#include <string.h>                      // MD
#include <filter.h>                      // MD

#include "Talkthrough.h"
#include "sysreg.h"
#include "ccblkfn.h"

#include "codec_buffers.h"               // MD
#include "iir2lib.h"                     // MD
#include "filters.h"                     // MD

//--------------------------------------------------------------------------//
// Variables                                                                                                                            //
//                                                                                                                                                      //
// Description: The variables iChannelxLeftIn and iChannelxRightIn contain      //
//                              the data coming from the codec AD1836.  The (processed)         //
//                              playback data are written into the variables                            //
//                              iChannelxLeftOut and iChannelxRightOut respectively, which      //
//                              are then sent back to the codec in the SPORT0 ISR.              //
//                              The values in the array iCodec1836TxRegs can be modified to //
//                              set up the codec in different configurations according to   //
//                              the AD1885 data sheet.                                                                          //
//--------------------------------------------------------------------------//
// left input data from ad1836
int iChannel0LeftIn, iChannel1LeftIn;
// right input data from ad1836
int iChannel0RightIn, iChannel1RightIn;
// left ouput data for ad1836
int iChannel0LeftOut, iChannel1LeftOut;
// right ouput data for ad1836
int iChannel0RightOut, iChannel1RightOut;
// array for registers to configure the ad1836
// names are defined in "Talkthrough.h"
volatile short sCodec1836TxRegs[CODEC_1836_REGS_LENGTH] =
{
                                        DAC_CONTROL_1   | 0x000,
                                        DAC_CONTROL_2   | 0x000,
                                        DAC_VOLUME_0    | 0x3ff,
                                        DAC_VOLUME_1    | 0x3ff,
                                        DAC_VOLUME_2    | 0x3ff,
                                        DAC_VOLUME_3    | 0x3ff,
                                        DAC_VOLUME_4    | 0x3ff,
                                        DAC_VOLUME_5    | 0x3ff,
                                        ADC_CONTROL_1   | 0x000,
                                        ADC_CONTROL_2   | 0x180,
                                        ADC_CONTROL_3   | 0x000

};
// SPORT0 DMA transmit buffer
volatile int iTxBuffer1[8];
// SPORT0 DMA receive buffer
volatile int iRxBuffer1[8];


//--------------------------------------------------------------------------//
// Function:    main                                                                                                            //
//                                                                                                                                                      //
// Description: After calling a few initalization routines, main() just         //
//                              waits in a loop forever.  The code to process the incoming  //
//                              data can be placed in the function Process_Data() in the        //
//                              file "Process_Data.c".                                                                          //
//--------------------------------------------------------------------------//


void main(void)
{


        sysreg_write(reg_SYSCFG, 0x32);     //Initialize System Configuration Register
        Init_EBIU();
        Init_Flash();
        Init1836();
        Init_Sport0();

        Init_Buffers();                     // MD (!!! musi byt pred Init_Sport_Interrupts()
        iir2_init(BIQ_COUNT);               // MD inicializacia filtrov

        Init_DMA();
        Init_Sport_Interrupts();
        Enable_DMA_Sport0();


// MD realizacia blokovej IIR filtracie
        while(1) {
            if(New_Blocks_Received==1) {    // FINISHED ->from AD to A, from A to DA
                iir2_fr16(Left_In0_A, Left_Out0_A, BLOCK_SIZE, &state_left);
                iir2_fr16(Right_In0_A, Right_Out0_A, BLOCK_SIZE, &state_right);
                memcpy(Left_Out1_A, Left_In1_A, 2*BLOCK_SIZE);
                memcpy(Right_Out1_A, Right_In1_A, 2*BLOCK_SIZE);
                New_Blocks_Received = 0;    // signalizacia spracovania bloku
            }
            if(New_Blocks_Received==2) {    // FINISHED ->from AD to B, from A to DA
                iir2_fr16(Left_In0_B, Left_Out0_B,BLOCK_SIZE, &state_left);
                iir2_fr16(Right_In0_B,Right_Out0_B, BLOCK_SIZE, &state_right);
                memcpy(Left_Out1_B,Left_In1_B,2*BLOCK_SIZE);
                memcpy(Right_Out1_B,Right_In1_B,2*BLOCK_SIZE);
                New_Blocks_Received = 0;    // signalizacia spracovania bloku
            }
      }
}
