/*

   High Performance 16-bit IIR Filter Function for Analog Devices Blackfin DSPs
   ----------------------------------------------------------------------------
   Authors: M. Drutarovsky, M. Kral, M. Nemcik

   Technical  University of Kosice
   Department of Electronics and Multimedia Communications
   Park Komenskeho 13
   041 20 Kosice
   Slovakia

   Tel: +421 (55) 602 41 69
   Fax: +421 (55) 632 39 89
   Email: Milos.Drutarovsky@tuke.sk

   Description:
   This function implements IIR filter as a cascade of biquads.
   Implemented biquad differential equation:

          y(n) = b0*x(n) + b1*x(n-1) + b2*x(n-2) + a1*y(n-1) + a2*y(n-2)

   Coefficients are ordered as following:
	  biquad 1 -> 1b1/2, 1b2/2, 1a2/2, 1b0/2, 1a1/2
	  biquad 2 -> 2b1/2, 2b2/2, 2a2/2, 2b0/2, 2a1/2
	  biquad 3 -> 3b1/2, 3b2/2, 3a2/2, 3b0/2, 3a1/2

		          ......


   Features:
   - all stable biquads are supported (coefficient have to be properly
     scaled)
   - _length and number of biquads MUST BE EVEN!
   - iir2_fr16 function can reach asymptotically 2.5 cycle/sample/biquad
     (requires placement of coefficients and filter delay line in
      separate L1 data segments)
   - tested on BF533 rev_0.4 hardware (EZ_KIT Lite)



   Version: 1.00                 Last revision: 2007-05-01


   Details are available in the paper:

   M. Drutarovsky, "An Implementation of High Performance IIR Filtration
   on 2-MAC Blackfin DSP Architecture," Proceedings of the 6th International
   Scientific Conference on Digital Signal Processing and Multimedia
   Communications - DSP-MCOM 2005, September 13-14, 2005, Kosice, Slovakia,
   pp.110-113, available on-line at
   http://www.kemt.fei.tuke.sk/publication/Drutarovsky/dspmcom2005.pdf

*/

void iir2_fr16 (const fract16 _input[],
                       fract16 _output[], int _length,
                       _iir_fr16_state *_filter_state);

