/*
  MD filtre pouzite v projekte
*/

#include <filter.h>
#include <fract.h>
#include <string.h>

#include "filters.h"

#define COEF_COUNT      5*BIQ_COUNT     // pocet koeficientov
#define DELAY_SIZE      2*BIQ_COUNT+2   // velkost oneskorovacej linky

_iir_fr16_state state_left;             // struktura iir filtra pre lavy kanal
_iir_fr16_state state_right;            // struktura iir filtra pre pravy kanal

// MD koeficienty filtra
fract16 iir2_coef[ 5*BIQ_COUNT ] = {
                              B11,B21,A21,B01,A11,
                              B12,B22,A22,B02,A12,
                              B13,B23,A23,B03,A13,
                              B14,B24,A24,B04,A14,
                              B15,B25,A25,B05,A15,
                              B16,B26,A26,B06,A16
                                                         };



// je sice potrebne obsah prekopirovat, je to vsak pre
// aplikacneho programatora citatelnejsie ako inicializacia
// prijamo v ASM kode

#pragma align 4
static segment("L1_data_a")
fract16 coef[COEF_COUNT];        // bufer pre koeficienty (v L1_a pamati)

#pragma align 4
static segment("L1_data_b")
fract16 delay_left[DELAY_SIZE];  // oneskorovacia linka (v L1_b pamati)

#pragma align 4
static segment("L1_data_b")
fract16 delay_right[DELAY_SIZE]; // oneskorovacia linka (v L1_b pamati)

void iir2_init(int stages)
{
    int i;
    memcpy( coef, iir2_coef, 10*stages );       // do L pamate
// nulovanie oneskorovacich liniek
    for (i=0;i<(2*stages+2);i++) {
           delay_left[i] = 0;
           delay_right[i] = 0;
    }
// inicializacia stavovych premennych
    iir_init(state_left, coef, delay_left, stages);
    iir_init(state_right, coef, delay_right, stages);

}


