// MD funkcie pre pracu s BLOKMI dat v preruseni

#include "Talkthrough.h"          // deklaracie premenych s AD a DA datami
#include "codec_buffers.h"        // prototypy funkcii pre pracu s buframi

// vstupne a vystupne bufre pre tzv. "ping pong" spracovanie (_A resp. _B)
// (da sa to realizovat aj s mensim poctom bufrov!!!)
// bufre obsahuju 16-bitove data (kodek pracuje interne so 24-bitovymi datami!!!)

// bufre pre smer AD - > bufre
#pragma align 4
short Left_In0_A[BLOCK_SIZE];
#pragma align 4
short Left_In1_A[BLOCK_SIZE];
#pragma align 4
short Left_In0_B[BLOCK_SIZE];
#pragma align 4
short Left_In1_B[BLOCK_SIZE];
#pragma align 4
short Right_In0_A[BLOCK_SIZE];
#pragma align 4
short Right_In1_A[BLOCK_SIZE];
#pragma align 4
short Right_In0_B[BLOCK_SIZE];
#pragma align 4
short Right_In1_B[BLOCK_SIZE];
// bufre pre smer bufre -> DA
#pragma align 4
short Left_Out0_A[BLOCK_SIZE];
#pragma align 4
short Left_Out1_A[BLOCK_SIZE];
#pragma align 4
short Left_Out0_B[BLOCK_SIZE];
#pragma align 4
short Left_Out1_B[BLOCK_SIZE];
#pragma align 4
short Right_Out0_A[BLOCK_SIZE];
#pragma align 4
short Right_Out1_A[BLOCK_SIZE];
#pragma align 4
short Right_Out0_B[BLOCK_SIZE];
#pragma align 4
short Right_Out1_B[BLOCK_SIZE];

static int cnt=0;                  // pocitadlo prijatych vzoriek
static int Ping_Pong = 0;          // 0  => from AD to A, from B to DA
                                   // !0 => from AD to B, from A to DA

// signalizuje aplikacii prijatie kompletnych blokov
volatile int New_Blocks_Received;  // 1 => AD to A_Blocks,
                                   // 2 => AD to B_Blocks


// pociatocna incializacia bufrov a premennych
void Init_Buffers( void )
{
 int k;
 cnt = 0;
 Ping_Pong = 0;
 for( k=0; k< BLOCK_SIZE; k++) {
  	Left_In0_A[k] = 0;
  	Left_In1_A[k] = 0;
  	Right_In0_A[k] = 0;
  	Right_In1_A[k] = 0;
  	Left_Out0_A[k] = 0;
  	Left_Out1_A[k] = 0;
  	Right_Out0_A[k] = 0;
  	Right_Out1_A[k] = 0;
  	Left_In0_B[k] = 0;
  	Left_In1_B[k] = 0;
  	Right_In0_B[k] = 0;
  	Right_In1_B[k] = 0;
  	Left_Out0_B[k] = 0;
  	Left_Out1_B[k] = 0;
  	Right_Out0_B[k] = 0;
  	Right_Out1_B[k] = 0;
 }
}


// funkcia prepisuje (24-bitove) data z AD do 16-bitoveho bufra, spatne
// zapisuje 16-bitove data do 24-bitoveho DA
// kedze sa pouzivaju IIR filtre pre 16-bitove data, je tato uspora miesta
// v pamati vyhodna

void Fill_Buffers( void )
{

        if (Ping_Pong ) {   // z AD (24-bit) do B (16-bit), z B (16-bit) do DA (24-bit)
     // from AD
           Left_In0_B[cnt] =  (short) (iChannel0LeftIn>>16);
           Left_In1_B[cnt] =  (short) (iChannel1LeftIn>>16);
  		   Right_In0_B[cnt] = (short) (iChannel0RightIn>>16);
  		   Right_In1_B[cnt] = (short) (iChannel1RightIn>>16);
  	// to DA
 		   iChannel0LeftOut = Left_Out0_B[cnt]<<16;
  		   iChannel1LeftOut = Left_Out1_B[cnt]<<16;
  		   iChannel0RightOut = Right_Out0_B[cnt]<<16;
  		   iChannel1RightOut = Right_Out1_B[cnt]<<16;
        }
        else {              // z AD (24-bit) do B (16-bit), z B (16-bit) do DA (24-bit)
    // from AD
  		   Left_In0_A[cnt] = (short) (iChannel0LeftIn>>16);
  		   Left_In1_A[cnt] = (short) (iChannel1LeftIn>>16);
  		   Right_In0_A[cnt] = (short) (iChannel0RightIn>>16);
  		   Right_In1_A[cnt] = (short) (iChannel1RightIn>>16);
  	// to DA
  		   iChannel0LeftOut = Left_Out0_A[cnt]<<16;;
  		   iChannel1LeftOut = Left_Out1_A[cnt]<<16;;
  		   iChannel0RightOut = Right_Out0_A[cnt]<<16;;
  		   iChannel1RightOut = Right_Out1_A[cnt]<<16;;
        }
        cnt++;
        if (cnt>=BLOCK_SIZE) {
         	cnt = 0;
         	if (Ping_Pong) {
         	   Ping_Pong = 0;
  		   New_Blocks_Received = 2;
         	}
         	else {
         	   Ping_Pong = 1;
		   New_Blocks_Received = 1;
         	}
        }
}


