///////////////////////////////////////////////////////////////
// 
//  STDIO_UART
//
// Creates new STDIO Device Driver for UART I/O
//
//(C) Copyright 2004 - Analog Devices, Inc.  All rights reserved.
//File Name:        main.c
//Date Modified:	03/19/04	
//
//Hardware:		ADSP-BF533 EZ-KIT Lite Board
//
//Special Connections:  
//		- EIA-232 Serial Cable (1:1)
//		- Terminal Program (i.e. Hyperterminal for Windows)
//		- 2400 bits per second (default)
//		- 8-bit, no parity, 1 stop bit
//		- no handshake
//		- echo off
//
//Purpose:	
//          - Registering New STDIO Device Driver for UART I/0
//          - Redirect Stdin/Stdout to New STDIO Device Driver
//          - (optional)Autobaud Detection using GP Timer 2
//	
//Steps:
//          - Build and Run 
//          - Open a Terminal Program (i.e. Hyperterminal for Windows)
//          - "Hello World" will print to Terminal Program
//          - "Type in something, press <Enter>, and I'll repeat it backwards!"
//			
///////////////////////////////////////////////////////////////

#include <stdlib.h>
#include <device.h>
#include <device_int.h>
#include <stdio.h>
#include <string.h>


unsigned short CLKIN = 27;  
// CLKIN frequency is 27MHz on the ADSP-BF533 EZ-Kits.
// If using a different BF board, then change this variable to
// your new board's CLKIN frequency. 


#define BAUDRATE      2400
// Default baudrate = 2400.
// You can change to any baudrate that matches your Terminal Program baudrate.
// Else set this #define to 0 for auto baud rate detection. Start auto baud
// rate detection by entering "@" inside Terminal Program. 


#define UART_DEVICEID  2
#define MAX_BUF        128
void backwards ( char *buf );
extern DevEntry UART_DevEntry;

///////////////////////////////////////////////////////////////
int main ()
{
	// Create new device ID.  The device ID is arbitrary and used globally in the application.
	// The data member is user-definable.  We are using it to set the desired baud rate.
	
	int result = 0;	
	static char buf[MAX_BUF];
	
	
	UART_DevEntry.DeviceID = UART_DEVICEID;
	UART_DevEntry.data     = (void *) BAUDRATE;
	
	// Insert this new device into the device table.
	
	result = add_devtab_entry ( &UART_DevEntry );
	
	set_default_io_device( UART_DEVICEID );
	
	// Redirect Stdio for printf and scanf 
	
	FILE *fp;
	 
	fp = freopen("", "a+", stdin);
	fp = freopen("", "a+", stdout);	
	
	printf("\n\r================\n\r");
	printf("Hello, World!\n\r");
	printf("Type in something, press <Enter>, and I'll repeat it backwards!\n\r");

	scanf ( "%s", buf );
	backwards ( buf );
	
	return 0;
}
///////////////////////////////////////////////////////////////
void backwards ( char *buf )
{
	int first = 0;
	int last = strlen ( buf ) - 1;
	
	while ( first < last )
	{
		char temp = buf [first];
		buf[first] = buf[last];
		buf[last] = temp;
		
		++first;
		--last;
	}
	
	printf ( "Backwards, you typed \"%s\".\r\n", buf );
}
///////////////////////////////////////////////////////////////
