% Subor testuje vystup FIR filtra vypocitany v prostredi VisualDSP

SCALE = 2^15;
DATASIZE = 256*10               % pocet testovanych vzoriek

inFile = fopen('x.dat','rb');	% subor so vstupnymi vzorkami (format 16.0)
[x,cnt] = fread(inFile,DATASIZE,'short');
x = x/SCALE;		% prevod do formatu 1.15

outFile = fopen('y.dat','rb');	% subor s vystupnymi vzorkami z VisualDSP simulacie (format 16.0)
[y,cnt] = fread(outFile,DATASIZE,'short');
y = y/SCALE;		% prevod do formatu 1.15

load coefs.txt;		% koeficienty FIR filtra vo formate (1.15)
h = coefs;
N = length(h);		% pocet koeficientov FIR filtra

y_ref = filter(h,1,x);		% referencny vypocet FIR filtra v Matlabe 

e = y - y_ref;		% rozdiel medzi VisualDSP a Matlabom

plot(e);        	% max chyba by mala byt radovo 2^(-15)
title('Chyba vypoctu v ADSP Blackfin');
xlabel('Vzorka');
ylabel('Chyba');
grid;