
clear all;
clc;
% generuje data v binarnom formate (x.dat) 


SCALE = 2^15; % konverzia z 1.15 na 16.0
DATASIZE = 2^9;%256*10 % pocet generovanych vzoriek

Fvz = 48000; % vzorkovacia frekvencia
A1 = 0.3; % amplituda 1. harmonickeho signalu
F1 = 2000; % frekvencia 1. harmonickeho signalu

n=(1:DATASIZE); % diskretny cas

x = A1*sin(2*pi*F1*n/Fvz); 

x = round( x*SCALE)' % konverzia do formatu 16.0

outFile = fopen('x_p.dat','wb');
save x_p.txt x -ascii % ulozenie vzoriek do suboru v ASCII formate (pre referencny vypocet)
fwrite(outFile,x,'short'); % ulozenie vzoriek v binarnom formate (2 bajty/vzorku) pre VisualDSp++
fclose(outFile);


% subplot(2,1,1)
% plot(x)
% 
% y=fft(x);
% subplot(2,1,2)
% plot(abs(y))
 
