% generuje data v binarnom formate (x.dat)

SCALE = 2^15;           % konverzia z 1.15 na 16.0
DATASIZE = 2^9;         % pocet generovanych vzoriek

Fvz = 48000;            % vzorkovacia frekvencia
A1 = 0.2;               % amplituda 1. harmonickeho signalu
A2 = 0.2;
A3 = 0.2
A4 = 0.2;
F1 = 2000;              % frekvencia 1. harmonickeho signalu
F2 = 3300;
F3 = 7700;
F4 = 13245;

n=(1:DATASIZE);         % diskretny cas

x = A1*sin(2*pi*F1*n/Fvz) +  A2*sin(2*pi*F2*n/Fvz) +  A3*sin(2*pi*F3*n/Fvz) +  A4*sin(2*pi*F4*n/Fvz) ;

x = round( x*SCALE)' % konverzia do formatu 16.0

outFile = fopen('x_p.dat','wb');
save x_p.txt x -ascii   % ulozenie vzoriek do suboru v ASCII formate (pre referencny vypocet)
fwrite(outFile,x,'short'); % ulozenie vzoriek v binarnom formate (2 bajty/vzorku) pre VisualDSp++
fclose(outFile);



