SCALE = 2^15;                           % konverzia z 1.15 na 16.0
DATASIZE = 2^9;                         % pocet generovanych vzoriek

inFile = fopen('x_p.dat','rb');         % subor so vstupnymi vzorkami (format 16.0)
[x,cnt] = fread(inFile,DATASIZE,'short');

% podla manulau je vo funkcii rfft_fr16 realizovane delenie vstupnych vzoriek
% faktorom 1/DATASIZE. Nasledujuci riadok simuluje toto delenie v 16-bitovej presnosti
x = DATASIZE*round(x/(DATASIZE));       % simuluje skalovanie v RealFFT algoritme
x_scale = x/SCALE;                      % prevod do formatu 1.15

%******** z DSP
outFile = fopen('y_p.dat','rb');        % subor s vystupnymi vzorkami z VisualDSP simulacie (format 16.0)
[y,cnt] = fread(outFile,DATASIZE,'short');
y_scale = y/SCALE;                      % prevod do formatu 1.15

%***********FFT v matlabe
y_matlab=fft(x_scale);

%****rozdiel
rozdiel=abs(y_matlab/DATASIZE)-y_scale; % VisualDSP skaluje data faktorom 1/DATASIZE

% ****vykreslenie****

%signal
subplot(3,1,1)
plot(x_scale)
title('Signal v casovej oblasti')

%matlab
subplot(3,1,2)
plot(abs(y_matlab))
title(' FFT vypocitana v Matlabe (bez skalovania 1/n)')

%DSP
subplot(3,1,3)

plot(y_scale)
title(' FFT vypocitana vo Visual DSP++')

% Chyba DSP vs. Matlab
figure(2)
plot(rozdiel)
grid
title('Chyba vypoctu RFFT voci Matlabu');

