% Subor testuje vystup IIR filtra (realizovany pomocou biquadov) vypocitany v prostredi VisualDSP

FRACT=2^15;
load coef.dat;		% koeficienty IIR filtra (biquadov) v celociselnom formate (16.0)
                        % v tvare (v skutocnosti su zapisane ako stlpcovy vektor!)
                        %         b2, b1, b0, a2, a1  <- 1.sekcia
                        %         b2, b1, b0, a2, a1  <- 2.sekcia
                        %         b2, b1, b0, a2, a1  <- 3.sekcia
                        %            ...
% nasledujuce prikazy prekonvertuju skalovane koeficienty do formatu 1.15
c= coef/FRACT;		% koeficienty biquadov v zlomkovom formate (1.15)
load scal.dat           % skalovacie konstanty pre 1., 2., 3, ... sekciu
n=max(size(c))/5;	% poced biquad sekcii
c=reshape(c,5,n)';	% riadky obsahuju koeficienty jednotlivych biquadov
c=c.*(2.^scal*ones(1,5));

load x.dat;		% vstupne vzorky (format 1.15)
load y.dat;		% vysledky vypocitane vo VisualDSP (format 1.15)

% filtracia kaskadou biquadov
for k=1:n
    b=[c(k,3) c(k,2) c(k,1)];  % [b0 b1 b2]
    a=[1 -c(k,5) -c(k,4)];     % [1 -a1 -a2]
    yy=filter(b,a,x);   % filtracia k-tym biquadom
    x=yy;               % vystup je vstupom pre dalsiu sekciu
end

m1 = max(size(yy));	% velkost yy
m2 = max(size(y));	% velkost y
m = min(m1,m2);
e = yy(1:m) - y(1:m);	% rozdiel medzi Matlabom a VisualDSP
plot(e);        	% max chyba
title('Chyba vypoctu IIR filtra v ADSP218x');
xlabel('Vzorka');
ylabel('Chyba');
grid;


