/************************************************************************
Nazov suboru:           IIR_test.asm

Datum modifikacie:      24-05-2002 MD


Opis:                   Demonstruje inicializaciu a cinnost IIR filtra
                        implementovaneho v procesore ADSP2181. Priklad
                        vyuziva kaskadne zapojenie BIKVADOV s jednoduchou
                        presnostou. Vtupne data a koeficienty su v
                        zlomkovom formate 1.15, skalovacie faktory vo formate
                        16.0.
                        Vstupne vzorky su nacitavane z prijimacieho registra
                        RX1 serioveho rozhrania SPORT1 a filtrovane udaje su
                        zapisovane do vysielacieho registra TX1 portu SPORT1.
************************************************************************/

/*
.CONST  N = 1;             { number of bikvad sections, example: 3 }
.CONST  N_x_5 = 15;        { number of bikvad sections times five }

.VAR/DM delayline[4];      { this is scratchpad memory }
.VAR/DM scalelist[N];      { initialize with the scale factor for each bikvad }
.VAR/PM coefflist[N_x_5];  { init with filter coefficients for each bikvad }
*/


#define     N                3           /* pocet bikvad sekcii */
#define     Ncoef          5*N           /* pocet koeficientov (5 koef/bikvad) */
#define     Nline        2*N+2           /* 4 prvky na bikvad, 2 zdielane s nasledujucim */
#define     Fvz            256           /* deliaci pomer 256 */

.EXTERN bikvad;

/* datova pamat - DM data */
.section/data data1;
.VAR    Delay_Line[2*N+2];              /* oneskorovacia linka */
.VAR/circ  Scale_List[N] = "scal.dat";  /* skalovacie faktory pre bikvady */


/* programova pamat - PM data */
.section/pm data2;
.VAR/circ   COEFF[Ncoef] = "coef.dat";  /* skalovane koeficienty bikvadov v tvare
                                           B2, B1, B0, A2, A1, ... B2, B1, B0, A2, A1 */
.section/pm  interrupts;
                                        /* --tabulka interuptovych vektorov-- */
__reset: JUMP start; NOP; NOP; NOP;     /* resetovaci vektor */
        RTI; NOP; NOP; NOP;             /* IRQ2 */
        RTI; NOP; NOP; NOP;             /* IRQL1 */
        RTI; NOP; NOP; NOP;             /* IRQL2 */
        RTI; NOP; NOP; NOP;             /* SPORT0 vysielanie*/
        RTI; NOP; NOP; NOP;             /* SPORT0 prijem */
        RTI; NOP; NOP; NOP;             /* IRQE */
        RTI; NOP; NOP; NOP;             /* BDMA */
        RTI; NOP; NOP; NOP;             /* SPORT1 vysielanie */
        JUMP sample; NOP; NOP; NOP;     /* SPORT1 prijem */
        RTI; NOP; NOP; NOP;             /* casovac */
        RTI; NOP; NOP; NOP;             /* znizeny prikon (Power down) */

.section/pm  program;
                                        /* -----inicializacia----- */
/***Inicializacia serioveho portu a zakladnych riadiacich registrov***/
/* aj ked nasledujuci kod este nie je urceny pre konkretne technicke
   prostriedky, jeho filozofia sa priblizuje praktickemu vyuzitiu.
   Vstupne vzorky sa nacitavaju z prijimacieho registra SPORT1 (RX1)
   a po filtracii, ktora je realizovana v prijimacom interrupte SPORT1,
   su filtrovane vzorky zapisovane do vysielacieho registra SPORT1 (TX1)
*/
start:
        AX0=0x0000;
        DM(0x3FFE)=AX0;                 /* vsetky DM pouzivaju 0 cakacich stavov */
        DM(0x3FFD)=AX0;                 /* casovac je nepouzity */
        DM(0x3FFC)=AX0;                 /* nulovanie registrov */
        DM(0x3FFB)=AX0;
        DM(0x3FFA)=AX0;                 /* viackanalove prijimanie */
        DM(0x3FF9)=AX0;                 /* zakazane */
        DM(0x3FF8)=AX0;                 /* viackanalove prijimanie */
        DM(0x3FF7)=AX0;                 /* zakazane */
        DM(0x3FF6)=AX0;                 /* riadenie SPORT0 nepouzite */
        DM(0x3FF5)=AX0;                 /* casovanie SPORT0 nepouzite */
        DM(0x3FF4)=AX0;                 /* casovanie SPORT0 nepouzite */
        DM(0x3FF3)=AX0;                 /* autobufer SPORT0 nepouzity */
/* konfiguracia SPORT1 */
        AX0=0x6B1F;                     /* interne seriove hodiny */
        DM(0x3FF2)=AX0;                 /* RFS reqd, normalny ramec,*/
                                        /* TFS reqd, normalny ramec,*/
                                        /* interne RFS, TFS, */
                                        /* bez kompresie, 16-bitove slova */

        AX0=0x0002;                     /* generuje 2.048 MHz SCLK1*/
        DM(0x3FF1)=AX0;                 /* z 12.288 MHz CLKIN */
        AX0=Fvz-1;                      /* deli SCLK1 256 pre 8 kHz */
        DM(0x3FF0)=AX0;                 /* vzorkovaciu frekvenciu */
        AX0=0x0000;
        DM(0x3FEF)=AX0;                 /* autobufer SPORT1 nepouzity */

        I0=Delay_Line; M0=1; L0=0;      /* incializacia smernika na oneskorovaciu linku */
        I1=Scale_List;                  /* incializacia smernika na skalovacie faktory */
        M1=-3;
        L1=LENGTH (Scale_List);         /* !!!!inicializacia modulo adresovania */
        I4=COEFF; M4=1;                 /* incializacia smernika na koeficienty */
        L4=length(COEFF);               /* inicializacia modulo adresovania */
        M3=1-Nline;

        M2=1;
        CNTR=LENGTH(Delay_Line);        /* nulovanie oneskorovacej linky */
        DO zero UNTIL CE;
zero:   dm(I0,M2)=0;                    /* nulovanie oneskorovacej linky */
        M2=1;                           /* !!!viac ako jedna sekcia */
        ICNTL=0x07;                     /* povolenie (edge sensitive) IRQs*/
        IMASK=0x02;                     /* povolenie prijimacieho int. od SPORT1 */

        AX0=0x0C00;                     /* SPORT1 povoleny, cakacie stavy */
        DM(0x3FFF)=AX0;                 /* PM=0, boot cakacie stavy=0, */
                                        /* zavadzacia stranka (boot page) 0 */
        DIS M_MODE;                     /* zlomkovy mod MAC jednotky */

/*------ Cakanaie na vzorku ------------*/
receive:IDLE;                           /* cakanie na prerusenie od prijimaca */
        Jump receive;

/*------ Spracovanie vzorky ------------*/
sample: SR1=RX1;                        /* zapis prijatej vzorky do SR1 */
        CNTR=N;                         /* inicializacia pocitadla bikvadov */
        I0=Delay_Line;
        call bikvad;                    /* volanie podprogramu IIR filtra */

        TX1=SR1;                        /* vyselanie filtrovanej vzorky (v SR1) */
        RTI;                            /* navrat z prerusenia */


