/**************************************************************

Nazov suboru:           BIKVAD.asm

Datum modifikacie:      17-03-2002 MD


Opis:                   Podprogram realizuje kaskadne zapojenie bikvad sekcii IIR filtra

Parametre:              SR1 = vstupna vzorka X(n)
                        I0 --> ukazuje na oneskorovaciu linku X(n-2), X(n-1), Y(n-2), Y(n-1)
                        L0 = 0
                        I1 --> ukazuje na skalovacie faktory pre kazdu bikvad sekciu
                        L1 = 0 (v pripade jedneho bikvadu)
                        L1 = pocet bikvad sekcii (v pripade viacerych bikvadov)
                        I4 --> skalovane koeficienty B2,B1,B0,A2,A1,  N2,B1,B0,A2,A1, ...
                        L4 = 5x pocet bikvadov
                        M0,M4 = 1
                        M1 = -3
                        M2 = 1  (v pripade viacerych bikvadov)
                        M2 = 0  (v pripade jedneho bikvadu)
                        M3 = (1 - dlzka oneskorovacej linky)
                        CNTR = pocet bikvad sekcii

Predpoklady:            Oneskorovacia linka musi mat dlzku N+2
                        Oneskorovacia linka je umiestnena v bloku DM.
                        Instrukcie a koeficienty su ulozene v bloku PM.

Navratove hodnoty:      SR1 = vystupna vzorka
                        I0 --> do oneskorovacej linky
                        I1 --> na zaciatok skalovcich faktorov
                        I4 --> zaciatok tabulky koeficientov filtra (v PM)

Zmenene registre:       MX0,MX1,MY0,MR,SE,SR

Pocet cyklov:           8*N/2 + 4 cyklov

Vyuzitie pamate:        Pocet datovych slov (16-bitovych):
                               5N  - pocet koeficientov (24-bitovych)
                              N+2  - pocet slov v oneskorovacej linke (16-bitovych)
                                N  - skalovacie faktory

Poznamky:               Vsetky koeficienty bikvadov  a vzorky su v zlomkovom formate 1.15
                        Skalovacie koeficienty su vo formate 16.0

**************************************************************/

.GLOBAL bikvad;

.section/pm program;

bikvad: DO sections UNTIL CE;
            SE=DM(I1,M2);
            MX0=DM(I0,M0), MY0=PM(I4,M4);                    /* nacita x(n-2), B2 */
            MR=MX0*MY0(SS), MX1=DM(I0,M0), MY0=PM(I4,M4);    /* nacita x(n-1), B1 */
            MR=MR+MX1*MY0(SS), MY0=PM(I4,M4);                /* nacita B0 */
            MR=MR+SR1*MY0(SS), MX0=DM(I0,M0), MY0=PM(I4,M4); /* nacita y(n-2), A2 */
            MR=MR+MX0*MY0(SS), MX0=DM(I0,M1), MY0=PM(I4,M4); /* nacita y(n-1), A1 */
            DM(I0,M0)=MX1, MR=MR+MX0*MY0(RND);   /* ulozi x(n-1) ako novu x(n-2) */
sections:   DM(I0,M0)=SR1, SR=ASHIFT MR1 (HI);   /* ulozi x(n) ako novu x(n-1)} */
        DM(I0,M0)=MX0;
        DM(I0,M3)=SR1;
        RTS;

