% Subor testuje vystup FIR filtra vypocitany v prostredi VisualDSP

load coef.dat;		% koeficienty FIR filtra v celociselnom formate (16.0)
                        % v tvare h(N), h(N-1), ..., h(1) t.j. otocene!!!
h = coef/2^15;		% koeficienty filtra v zlomkovom formate (1.15)
N = max(size(h));
for k=1:N
 hh(k) = h(N+1-k);	% transformacia do tvaru h(1), h(2), ... h(N)
end
load x.dat;		% vstupne vzorky (format 1.15)
load y.dat;		% vysledky vypocitane vo VisualDSP (format 1.15)
yy = filter(hh,1,x);	% referencny vypocet FIR filtra v Matlabe (pouzite
                        % otocene koeficienty!)

m1 = max(size(yy));	% velkost yy
m2 = max(size(y));	% velkost y
m = min(m1,m2);

e = yy(1:m) - y(1:m);	% rozdiel medzi Matlabom a VisualDSP

plot(e);        	% max chyba by mala byt 2^(-15)
title('Chyba vypoctu v ADSP218x');
xlabel('Vzorka');
ylabel('Chyba');
grid;