/**************************************************************

Nazov suboru:           FIR.asm

Datum modifikacie:      11-03-2002 MD


Opis:                   Podprogram realizuje FIR filter urceny koeficientami h(k) a
                        vstupnymi vzorkami x(n-k).

                        Rovnica:        y(n) = Suman pre k=0 do N-1 sucinov h(k)*x(n-k)

Parametre:              I0 --> ukazuje na najstarsiu vzorku v oneskorovacej linke
                        L0 = dlzka filtra (N)
                        I4 --> zaciatok tabulky koeficientov filtra (v PM)
                               POZOR, koeficienty musia byt v poradi:
                                        h(N-1), h(N-2), ..., h(1), h(0)
                        L4 = dlzka filtra (N)
                        M1,M5 = 1
                        CNTR = dlzka filtra-1 (N-1)

Predpoklady:            Oneskorovacia linka musi mat dlzku N
                        Oneskorovacia linka je umiestnena v bloku DM.
                        Instrukcie a koeficienty su ulozene v bloku PM.

Navratove hodnoty:      MR1 = sucet sucinov (zaokruhleny a saturovany)
                        I0 --> najstarsia vstupna vzorka v oneskorovacej linke
                        I4 --> zaciatok tabulky koeficientov filtra (v PM)

Zmenene registre:       MX0,MY0,MR

Pocet cyklov:           N - 1 + 5 + 2 cycles

Vyuzitie pamate:        Pocet instrukcnych slov (24-bitovych):
                                11 + N - 1 instrukcnych slov

                        Pocet datovych slov (16-bitovych):
                                N - pocet koeficientov (24-bitovych)
                                N - pocet slov v oneskorovacej linke (16-bitovych)

Poznamky:               Vsetky koeficienty a vzorky su v zlomkovom formate 1.15

**************************************************************/



.GLOBAL fir;

/* kod v programovej pamati */
.section/pm program;

fir:    MR=0, MX0=DM(I0+=M1), MY0=PM(I4+=M5); /* nulovanie MR, predvyber MX0, MY0 */
                DO sop UNTIL CE;              /* vypocet FIR filtra */
sop:            MR=MR+MX0*MY0(SS), MX0=DM(I0+=M1), MY0=PM(I4+=M5);
        MR=MR+MX0*MY0(RND);                   /* zaokruhlenie vysledku */
        IF MV SAT MR;                         /* pripadna saturacia vysledku */
        RTS;                                  /* navrat z podprogramu */


