/************************************************************************
Nazov suboru:           Fir_test.asm

Datum modifikacie:      07-03-2002 MD


Opis:                   Demonstruje inicializaciu a cinnost FIR filtra
                        implementovaneho v procesore ADSP2181. Priklad
                        vyuziva priamu formu FIR filtra s jednoduchou
                        presnostou. Vtupne data a koeficienty su v
                        zlomkovom formate 1.15.
                        Vstupne vzorky su nacitavane z prijimacieho registra
                        RX1 serioveho rozhrania SPORT1 a filtrovane udaje su
                        zapisovane do vysielacieho registra TX1 portu SPORT1.
************************************************************************/

#define     Ncoef            5           /* pocet koeficientov FIR filtra */
#define     Fvz            256           /* deliaci pomer 256 */

.EXTERN fir;

/* datova pamat - DM data */
.section/data data1;
.VAR/circ    Delay_Line[Ncoef];          /* oneskorovacia linka, klucove slovo */
                                         /* circ zabezpeci umiestnenie modulo */
										 /* bufra na spravnu pociatocnu adresu */

/* programova pamat - PM data */
.section/pm data2;
.VAR/circ   COEFF[Ncoef] = "coef.dat";  /* koeficienty filtra v tvare
                                           h(N-1), h(N-2, ... h(1), h(0) */
.section/pm  interrupts;
                                        /* --tabulka interuptovych vektorov-- */
__reset: JUMP start; NOP; NOP; NOP;     /* resetovaci vektor */
        RTI; NOP; NOP; NOP;             /* IRQ2 */
        RTI; NOP; NOP; NOP;             /* IRQL1 */
        RTI; NOP; NOP; NOP;             /* IRQL2 */
        RTI; NOP; NOP; NOP;             /* SPORT0 vysielanie*/
        RTI; NOP; NOP; NOP;             /* SPORT0 prijem */
        RTI; NOP; NOP; NOP;             /* IRQE */
        RTI; NOP; NOP; NOP;             /* BDMA */
        RTI; NOP; NOP; NOP;             /* SPORT1 vysielanie */
        JUMP sample; NOP; NOP; NOP;     /* SPORT1 prijem */
        RTI; NOP; NOP; NOP;             /* casovac */
        RTI; NOP; NOP; NOP;             /* znizeny prikon (Power down) */

.section/pm  program;
                                        /* -----inicializacia----- */
/***Inicializacia serioveho portu a zakladnych riadiacich registrov***/
/* aj ked nsaledujuci kod este nie je urceny pre konkretne technicke
   prostriedky, jeho filozofia sa priblizuje praktickemu vyuzitiu.
   Vstupne vzorky sa nacitavaju z prijimacieho registra SPORT1 (RX1)
   a po filtracii, ktora je realizovana v prijimacom interrupte SPORT1,
   su filtrovane vzorky zapisovane do vysielacieho registra SPORT1 (TX1)
*/
start:
        AX0=0x0000;
        DM(0x3FFE)=AX0;                 /* vsetky DM pouzivaju 0 cakacich stavov */
        DM(0x3FFD)=AX0;                 /* casovac je nepouzity */
        DM(0x3FFC)=AX0;                 /* nulovanie registrov */
        DM(0x3FFB)=AX0;
        DM(0x3FFA)=AX0;                 /* viackanalove prijimanie */
        DM(0x3FF9)=AX0;                 /* zakazane */
        DM(0x3FF8)=AX0;                 /* viackanalove prijimanie */
        DM(0x3FF7)=AX0;                 /* zakazane */
        DM(0x3FF6)=AX0;                 /* riadenie SPORT0 nepouzite */
        DM(0x3FF5)=AX0;                 /* casovanie SPORT0 nepouzite */
        DM(0x3FF4)=AX0;                 /* casovanie SPORT0 nepouzite */
        DM(0x3FF3)=AX0;                 /* autobufer SPORT0 nepouzity */
/* konfiguracia SPORT1 */
        AX0=0x6B1F;                     /* interne seriove hodiny */
        DM(0x3FF2)=AX0;                 /* RFS reqd, normalny ramec,*/
                                        /* TFS reqd, normalny ramec,*/
                                        /* interne RFS, TFS, */
                                        /* bez kompresie, 16-bitove slova */

        AX0=0x0002;                     /* generuje 2.048 MHz SCLK1*/
        DM(0x3FF1)=AX0;                 /* z 12.288 MHz CLKIN */
        AX0=Fvz-1;                      /* deli SCLK1 256 pre 8 kHz */
        DM(0x3FF0)=AX0;                 /* vzorkovaciu frekvenciu */
        AX0=0x0000;
        DM(0x3FEF)=AX0;                 /* autobufer SPORT1 nepouzity */

        I0=Delay_Line;                  /* incializacia smernika na oneskorovaciu linku */
        M1=1;
        L0=LENGTH (Delay_Line);         /* inicializacia modulo adresovania */
        I4=COEFF;                       /* incializacia smernika na koeficienty */
        L4=length(COEFF);               /* inicializacia modulo adresovania */
        M5=1;

        AX0=0;
        CNTR=Ncoef;                     /* 'Ncoef' pozicii v oneskorovacej linke */
        DO zero UNTIL CE;
zero:   dm(I0,M1)=AX0;                  /* nulovanie oneskorovacej linky */

        ICNTL=0x07;                     /* povolenie (edge sensitive) IRQs*/
        IMASK=0x02;                     /* povolenie prijimacieho int. od SPORT1 */

        AX0=0x0C00;                     /* SPORT1 povoleny, cakacie stavy */
        DM(0x3FFF)=AX0;                 /* PM=0, boot cakacie stavy=0, */
                                        /* zavadzacia stranka (boot page) 0 */
        DIS M_MODE;                     /* zlomkovy mod MAC jednotkz */

/*------ Cakanaie na vzorku ------------*/
receive:IDLE;                           /* cakanie na prerusenie od prijimaca */
        Jump receive;

/*------ Spracovanie vzorky ------------*/
sample: MX0=RX1;                        /* zapis prijatej vzorky do MX0 */
        DM(I0,M1)=MX0;                  /* zapis na najstarsiu poziciu v oneskorovacej
                                           linke */

        CNTR=Ncoef-1;                   /* inicializacia pocitadla pre FIR filter */
        call fir;                       /* volanie podprogramu FIR filtra */

        TX1=MR1;                        /* vyselanie filtrovanej vzorky (v MR1) */
        RTI;                            /* navrat z prerusenia */


