#include <ffts.h>
#include <signal.h>
#include <fract.h>

#include <sport.h>
#include <circ.h>

extern  int Real_Out[256], Imag_Out[256];

/* prva polovica kazdeho buffra obsahuje len realne casti vzoriek,
   druha polovica imaginarne casti vzoriek */
extern  int Buffer0[], Buffer1[];

/* Tieto pointre su vyuzite na rozdelenie pamate s velkostou 512 vzoriek na 2 pamate
   s velkostou 256 */
int * Buffer0_Imag;
int * Buffer1_Imag;

/* Priznak na prepinanie bufrovania. Vstupne data sa zapisuju cyklicky do dvoch vyrovnavacich
   pamati s velkostou 512, pricom priznak db_tgl urcuje, ktora pamat je aktivna. Do aktivnej
   sa udaje zapisuju pocas obsluhy prerusenia a druha je v tom istom case spracovavana v hlavnom
   programe pomocou (blokovej) FFT. */
int     db_tgl = 0;

/* Do_FFT priznak je nastaveny v case ked su platne udaje v jednej z cirkulacnych pamati. Tento
   priznak nastavuje obsluha prerusenia od prijimaca SPORT0 a informuje tak hlavny program, ze
   bol nacitany komletny blok udajov.
   Po nastaveni priznaku Do_FFT hlavny program spracuje prijaty blok a vynuluje priznak Do_FFT. */
int     DoFFT=0;

int max = 1;
int index = 1;
/* Nastavenie priznaku Bit_Reversal_On informuje obsluhu prerusenia, ze v hlavnom programe je
   pouzivana funkcia FFT, ktora pouziva bitovo-reverzne adresovanie. Hlavny program tak informuje
   obsluhu prerusenia o aktualnom nastaveni DAG1 jednotky, ktora pouziva bitovo reverzne adresovane.
   Podla tohto priznaku je riadene spracovanie preruseni od prijimaca portu SPORT0 */
int Bit_Reversal_On = 0;

/* Tato funckia je len parametrom volania funckie interrupt a v skutocnosti sa nevyvolava! */
void    SPORT0_Receive_Int( int sig_int )
{

}

int bexp;
main()
{
        int i;
 
	/* Nulovanie riadiaceho registra SPORT0 pre spravnu funkciu neskor pouzitych makier */
	asm("AX0=0; DM(0x3FF3)=AX0;");

		/* Nastavenie pointrov do stredu dvoch pracovnych bufrov Buffer0 a Buffer1 */
        Buffer0_Imag = Buffer0 + 256;
        Buffer1_Imag = Buffer1 + 256;

        /* Nastavenie serioveho portu SPORT0

           Nastavenie 10 Mhz internych hodin SCLK s 80Mhz hodinami */
        sport0.sclkdiv = COMPUTE_SCLKDIV(80000000, 10000000);

        /* Nastavenie RFS tak, aby bol generovany kazdych 20 SCLK periods
           RFS je ramcovy synchronizacny signal (Receive Frame Synchronization),
           ktory definuje presne okamihy, kedy prichadzaju platne data. SCLK potom
           definuje jednotlive bity a kedze RFS je aktivne kazdych 20 period SCLK,
           je mozne preniest (aj s rezervou) aj 16-bitove vzorky */
        sport0.rfsdiv = 20;

        /* Nastavenie riadiaceho registra SPORT0 */
        sport0.control.single.isclk     = 1;    // interne sclk
        sport0.control.single.irfs      = 1;    // interne RFS
        sport0.control.single.rfsr      = 1;    // RFS je vyzadovane
        sport0.control.single.slen      = 15;   // 16 bitove slova

        /* Nastavenie autobufrovacich registrov */
        sport0.autobuffer.receive_enable= 1;    // povoli autobfrovanie prijmu od SPORT0
        sport0.autobuffer.rmreg         = 1;    // M3 (=1 prednastavene v C prostredi)
        sport0.autobuffer.rireg         = 2;    // I2 (register je potrebne rezervovat)

        /* Nastavenie DAG registra i2 pre autobufrovanie a jeho inicializacia tak, aby ukazoval
           na _Buffer0 s dlzkou 512
           toto makro je mozne najst v circ.h */
        circ_setup(2, Buffer0, 512);

        /* start SPORT0 */
        sport_start(0);

        /* Definovanie C funkcie ktora by bola volana pri obsluhe prerusenia. V skutocnosti
           tato funkcia len povoli prislusne prerusenie. Pretoze v tabulke preruseni sme
           priamo definovali vlastnu funckiu, pri obsluhe prerusenie od prijimaca SPORT0 bude
           prerusenie spracovat nasa funkcia */
        interrupt(SIGSPORT0RECV, SPORT0_Receive_Int);

        for(;;)
        {
                asm("idle;");
                if (DoFFT)
                {
                        /* v tomto bode je v jednej z dvoch cirkulacnych pamati nacitany
                           kompletny blok N=512 vzoriek */

                        DoFFT = 0;	/* Vynulovanie priznaku (opat ho nastavi obsluha prerusenia
                                           po nacitani dalsieho bloku) */
                        if (!db_tgl)    // definuje v ktorej cirkulacnej pamati su platne data
                        {

                                /* Zakaze autobufrovanie a oznami to obsluhe prerusenia SPORT0
                                   nastavenim hodnoty Bit_Reversal_On na 1 */

                                Bit_Reversal_On = 1;
                                sport0.autobuffer.receive_enable = 0;    // zakazanie autobufrovania

                                bexp = fft256(Buffer1, Buffer1_Imag, Real_Out, Imag_Out);

                                /* Opatovne povolenie autobufrovaniaand a oznamenie obsluhe
                                   prerusenia nastavenim Bit_Reversal_On value na  0 */

                                sport0.autobuffer.receive_enable = 1;    // povolenie autobuferovania
                                Bit_Reversal_On = 0;

                        }
                        else    // to iste spracovanie pre Buffer0
                        {
                                Bit_Reversal_On = 1;
                                sport0.autobuffer.receive_enable = 0;

                                bexp = fft256(Buffer0, Buffer0_Imag, Real_Out, Imag_Out);

                                sport0.autobuffer.receive_enable = 1;
                                Bit_Reversal_On = 0;
                        }

                        /* Priklad najdenia maximalnej amplitudy v spektre vypocitanom pomocou FFT. 
                           Vysledky FFT (realna zlozka) su v nasledujucom vypocte prepisane  !!! */

                        max = 0;
                        for (i=0;i<128;i++)
                        {
                                Real_Out[i] = Real_Out[i]*Real_Out[i] + Imag_Out[i]*Imag_Out[i];
                                if (Real_Out[i] > max)
                                {
                                        max = Real_Out[i];
                                        index = i;
                                }
                        }

                }
        }
}
