LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;
USE ieee.std_logic_unsigned.ALL;

ENTITY example IS
  GENERIC(
    STEP    : integer :=   1   -- velkost kroku
  );
  PORT(
  clk       : IN   STD_LOGIC;   
  start     : IN   STD_LOGIC;   
  reset     : IN   STD_LOGIC;
  data      : OUT  STD_LOGIC_VECTOR(2*STEP DOWNTO 0)       
  );
END example;

ARCHITECTURE cviko OF example IS

-- State machine 
  TYPE SM_MAIN_TYPE IS (
    main_wait, 
    main_increase, 
    main_decrease, 
    main_finished
  );
  SIGNAL sm_main   : SM_MAIN_TYPE;
  SIGNAL increase  : STD_LOGIC;
  SIGNAL full      : STD_LOGIC;
  SIGNAL empty     : STD_LOGIC;
  SIGNAL sucet     : STD_LOGIC_VECTOR(2*STEP DOWNTO 0);

BEGIN
  
-- Main state machine
PROCESS(clk, reset)
BEGIN
  IF reset = '1' THEN
    sm_main <= main_wait;
  ELSIF clk'event AND clk = '1' THEN
    CASE sm_main IS
      WHEN main_wait =>
        IF start = '1' THEN
          sm_main <= main_increase;
        END IF;
        increase <= '1';
      WHEN main_increase =>
        IF (full = '1') THEN
         sm_main <= main_decrease;
         increase <= '0';
        END IF;
      WHEN main_decrease =>
        IF (empty = '1') THEN
         sm_main <= main_finished;
        END IF;
      WHEN main_finished =>
        sm_main <= main_wait;
    END CASE;
  END IF;
END PROCESS;

PROCESS(clk)
BEGIN
  IF clk'event AND clk = '1' THEN
    IF reset = '1' THEN 
      sucet <= (OTHERS => '0');
    ELSIF sm_main = main_increase THEN  
      sucet <= sucet + STEP;
    ELSIF sm_main = main_decrease THEN
      sucet <= sucet - STEP;
    ELSE
      sucet <= sucet;
    END IF;
  END IF;
END PROCESS;

data <= sucet;

PROCESS(clk)
BEGIN
  IF clk'event AND clk = '1' THEN
    IF sucet = 1 THEN  
      full  <= '0';
      empty <= '1';
    ELSIF sucet = (4*STEP)-1 THEN
      empty <= '0';
      full  <= '1';
    ELSE
      empty <= '0';
      full  <= '0';
    END IF;
  END IF;
END PROCESS;
  
END cviko;