#include <stdio.h>
#include <math.h>
#include <stdlib.h>

void zaciatok (FILE *subor)
{
	fprintf(subor, "WIDTH=8;\n");
	fprintf(subor, "DEPTH=256;\n\n");
	fprintf(subor, "ADDRESS_RADIX=DEC;\n");
	fprintf(subor, "DATA_RADIX=DEC;\n\n");
	fprintf(subor, "CONTENT BEGIN\n");
}

void koniec (FILE *subor)
{
	fprintf(subor, "END;");
}

int main ()
{
	FILE *subor;
	double PI = 3.1415927;
    double x;
	double vysledok;
	int i;

	if ((subor = fopen("sin.mif", "wt")) == NULL)
	{
	fprintf(stderr, "Nemozem vytvorit subor.\n");
	return 1;
	}

	zaciatok(subor);

	for (i=0; i<256; i++)
	{
		x = ((double)i/255)*2*PI;
		vysledok = (255/2) + sin(x)*(255/2);
		fprintf(subor, "%d\t:\t%d;\n", i, (int)vysledok);
    }                                                                    

	koniec(subor);

	fclose(subor);
	return 0;
}