library ieee;
use ieee.std_logic_1164.all;

entity citac_clear_set is
port
	(
	clock		: in	std_logic;
	smer		: in	std_logic;
	vynuluj		: in	std_logic;
	nastav		: in	std_logic;
	stav_citaca	: out	std_logic_vector (7 downto 0)
	);
end entity;

architecture arch of citac_clear_set is

-- deklaracia lpm funkcie (modulu)
COMPONENT my_lpm_counter IS
	PORT
	(
		clock	: IN STD_LOGIC ;
		updown	: IN STD_LOGIC ;
		sclr	: IN STD_LOGIC ;
		sset	: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (7 DOWNTO 0)
	);
END COMPONENT;

begin

-- vytvorenie instancie komponenty
my_lpm_counter_inst: my_lpm_counter
	PORT MAP
	(
		clock	=> clock,
		updown	=> smer,
		sclr	=> vynuluj,
		sset	=> nastav,
		q		=> stav_citaca
	);

end architecture;