library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library work;
use work.constants.all;

entity use_packages is
port
	(
	clock   : in   std_logic;
	vystup  : out  std_logic
	);
end entity use_packages;

architecture use_packages_arch of use_packages is
    signal counter   : std_logic_vector(LENGTH-1 downto 0);
    signal vystup_sig : std_logic;
begin

   process (clock)
       begin
           if (clock'event and clock='1') then
               counter <= counter + '1';
               if (counter = OFFSET) then
                   counter <= (OTHERS=>'0');
                   vystup_sig <= not vystup_sig;
               end if;
           end if;
       end process;
   
   vystup <= vystup_sig;
   
end architecture use_packages_arch;