library ieee;
use ieee.std_logic_1164.all;

entity signal_1t is
port
	(
	clock	: in	std_logic;
	vstup	: in	std_logic;
	vystup	: out	std_logic
	);
end entity signal_1t;

architecture signal_1t_arch of signal_1t is
	signal vstup_synchronizovany	: std_logic;
	signal vstup_oneskoreny	: std_logic;
begin

synchronizacia: process (clock)
begin
	if (clock'event and clock='1') then
		vstup_synchronizovany <= vstup;
	end if;
end process;

oneskorenie: process (clock)
begin
	if (clock'event and clock='1') then
		vstup_oneskoreny <= vstup_synchronizovany;
	end if;
end process;

vystup <= vstup_synchronizovany and not vstup_oneskoreny;

end architecture;