library ieee;                                                                                           --zadefinovanie kniznic		
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
USE IEEE.STD_LOGIC_TEXTIO.ALL;
USE STD.TEXTIO.ALL; 

--definovanie vstupov a vystupov
entity counter_up_tb is
generic
	(
		N : integer:= 9
	);
end entity counter_up_tb;

architecture counter_up_tb_arch of counter_up_tb is
   
   component counter_up is
   generic
	   (
		N : integer:= 9
	   );
   port
	   (
	   clk      : in	std_logic;			 		--hodiny
	   reset	   : in	std_logic;			 		--inicializcia citaca
	   vystup   : out	std_logic_vector (N downto 1)
	   );
	end component; 
   
	signal clk         : std_logic;
	signal reset       : std_logic;
	signal vystup      : std_logic_vector (N downto 1);
	
	constant clk_period   : time := 50 ns;
	
begin

DUT: counter_up port map (
   clk => clk,
   reset => reset,
   vystup => vystup
   );

--Clock signal generation
clk_gen : PROCESS
BEGIN
  clk <= '0';
  LOOP
     WAIT FOR (clk_period / 2);
     clk <= NOT clk;
  END LOOP;
END PROCESS clk_gen;

PROCESS(clk)
BEGIN
  IF clk'EVENT and clk='1' THEN
    IF vystup = 7 THEN
      reset <= '1';
    ELSE
      reset <= '0';
    END IF;  
  END IF;
END PROCESS;

stimulus : process
   VARIABLE riadok   : LINE; 
   FILE results      : TEXT OPEN WRITE_MODE IS "results.txt"; 
begin
      write(riadok, now); -- aktualny cas
      WRITE(riadok, string'(" vystup = "));
      WRITE(riadok, vystup);
      WRITELINE(results, riadok);
      wait for clk_period;
end process stimulus;

end architecture counter_up_tb_arch;

